% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfp_altapply.R
\name{cfp_altapply}
\alias{cfp_altapply}
\title{Apply a function over a list of models}
\usage{
cfp_altapply(X, FUN, ...)
}
\arguments{
\item{X}{Either a cfp_altres object or a list.}

\item{FUN}{the function to be applied to each element of \code{X}:
    see \sQuote{Details}.  In the case of functions like
    \code{+}, \code{\%*\%}, the function name must be backquoted or quoted.}

\item{...}{optional arguments to \code{FUN}.}
}
\value{
data.frame with the results of FUN bound together with added
column run_id as identifier of the original list elements.
}
\description{
Apply a function to a list of cfp_pfres pr cfp_fgres objects
stored in an cfp_altres object. This can be used to summarise
alternate() results.
}
\examples{
PROFLUX <- ConFluxPro::base_dat |> pro_flux()
model_list <- list('1' = PROFLUX, '2' = PROFLUX)

cfp_altapply(model_list, efflux)


}
