% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D0_massman.R
\name{D0_massman}
\alias{D0_massman}
\title{Calculate D0}
\usage{
D0_massman(gas, t, p)
}
\arguments{
\item{gas}{(character) One of "CO2","CH4","N2O","O2","N2"}

\item{t}{(numeric) temperature in °C}

\item{p}{(numeric) pressure in hpa}
}
\value{
A numeric vector of D0 in m^2/s
}
\description{
This function calculates the free-air diffusion coefficients
of different gases for a given temperature and pressure.
}
\examples{
D0_massman("CO2", 10, 1013)


}
\references{
Massman, W. J. A review of the molecular diffusivities of H2O,
CO2, CH4, CO, O3, SO2, NH3, N2O, NO, and NO2 in air, O2 and N2 near STP.
Atmospheric Environment 1998, 32(6), 1111–1127
}
