% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CensRate.OneArm.R
\name{CensRate.OneArm}
\alias{CensRate.OneArm}
\title{Calculate the censoring rate for a one-arm design}
\usage{
CensRate.OneArm(
  N = NULL,
  d = NULL,
  s = NULL,
  m = NULL,
  l = NULL,
  alpha = NULL,
  nu = NULL
)
}
\arguments{
\item{N}{Number of subjects plan to enrolled}

\item{d}{expected number of events observed at time \code{l}}

\item{s}{enrollment period}

\item{m}{maximum follow-up for a single subject}

\item{l}{observation time}

\item{alpha}{shape parameter of weibull survival distribution}

\item{nu}{scale parameter of weibull survival distribution}
}
\value{
This function returns a list containing all design parameters, including the calculated censoring rate \code{gamma}.
}
\description{
Calculate the censoring rate for a one-arm design
}
\examples{
CensRate.OneArm(N=100,d=10,l=10,s=12,m=6,alpha=1,nu=20)
}
