% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PIN.R
\name{PIN}
\alias{PIN}
\title{Piniles' rule}
\usage{
PIN(E, d, name = FALSE)
}
\arguments{
\item{E}{The endowment.}

\item{d}{The vector of claims.}

\item{name}{A logical value.}
}
\value{
The awards vector selected by the PIN rule. If \code{name = TRUE}, the name of the function (PIN) as a character string.
}
\description{
This function returns the awards vector assigned by the Piniles' rule (PIN) to a claims problem.
}
\details{
Let \eqn{N=\{1,\ldots,n\}} be the set of claimants, \eqn{E\ge 0} the endowment to be divided and \eqn{d\in \mathbb{R}_+^N} the vector of claims
such that \eqn{D=\sum_{i \in N} d_i\ge E}.

The Piniles' rule (PIN) coincides with the constrained equal awards rule (CEA) applied to
the problem \eqn{(E, d/2)} if the endowment is less or equal than the half-sum of the claims, \eqn{D/2}.
Otherwise it assigns to each claimant \eqn{i} half of the claim, \eqn{d_i/2}, and,
then, it distributes the remainder with the CEA rule. Therefore, for each \eqn{i\in N},

\deqn{\text{PIN}_i(E,d) = \begin{cases}
\min\{\frac{d_i}{2},\lambda\}      & \text{if } E\leq \tfrac{1}{2}D\\[3pt]
\frac{d_i}{2}+\min\{\frac{d_i}{2},\lambda\} & \text{if }  E \geq \tfrac{1}{2}D
\end{cases},}

where \eqn{\lambda \geq 0} is chosen such that  \eqn{\underset{i\in N}{\sum}	\text{PIN}_i(E,d)=E}.
}
\examples{
E=10
d=c(2,4,7,8)
PIN(E,d)
}
\references{
Piniles, H.M. (1861). Darkah shel Torah. Forester, Vienna.

Thomson, W. (2019). How to divide when there isn't enough. From Aristotle, the Talmud, and Maimonides to the axiomatics of resource allocation. Cambridge University Press.
}
\seealso{
\link{allrules}, \link{axioms}, \link{CEA}, \link{Talmud}.
}
