% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censored_errors.R
\name{CFM}
\alias{CFM}
\title{Censored Factor Models Data Generation}
\usage{
CFM(n, p, m, cens.dist = c("normal", "t", "logistic"), df = 5, seed = NULL)
}
\arguments{
\item{n}{sample size (\eqn{n \times 1} observations).}

\item{p}{number of manifest variables.}

\item{m}{number of latent factors.}

\item{cens.dist}{censoring error distribution:
\code{"normal"}, \code{"t"}, or \code{"logistic"}.}

\item{df}{degrees of freedom when \code{cens.dist = "t"}.}

\item{seed}{optional random seed for reproducibility.}
}
\value{
A named list with components:
  \item{data}{numeric \eqn{n \times p} matrix of observations.}
  \item{F}{factor scores matrix (\eqn{n \times m}).}
  \item{A}{factor loadings matrix (\eqn{p \times m}).}
  \item{D}{unique variances diagonal matrix (\eqn{p \times p}).}
}
\description{
Generate multivariate data that follow a latent factor structure
with censoring errors drawn from Normal, Student-t or Logistic
distributions.  Convenience wrapper around \code{\link[crch]{rcnorm}},
\code{\link[crch]{rct}}, and \code{\link[crch]{rclogis}}.
}
\examples{
\donttest{
set.seed(2025)
# Normal censoring
obj <- CFM(n = 200, p = 10, m = 3, cens.dist = "normal")
head(obj$data)

# t-censoring with 6 d.f.
obj <- CFM(n = 300, p = 12, m = 4, cens.dist = "t", df = 6)
psych::KMO(obj$data)
}

}
