% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{visualize_moving_circles}
\alias{visualize_moving_circles}
\title{Visualize Moving Circles Pattern}
\usage{
visualize_moving_circles(
  sim_data,
  bg_color = "grey90",
  signal1_color = "#16964a",
  signal2_color = "#2958a8",
  show_subtitle = TRUE,
  sort_order = c("ascending", "descending"),
  panel_spacing = 0.1,
  title_size = 12
)
}
\arguments{
\item{sim_data}{Output from simulate_moving_circles function}

\item{bg_color}{Background color for plots (default: "grey90")}

\item{signal1_color}{Color for signal 1 (default: "#16964a")}

\item{signal2_color}{Color for signal 2 (default: "#2958a8")}

\item{show_subtitle}{Logical; if TRUE (default), show parameter values in facet labels}

\item{sort_order}{Order for sorting ("ascending" or "descending", default: "ascending")}

\item{panel_spacing}{Control spacing between panels in lines (default: 0.1)}

\item{title_size}{Size of title text (default: 12)}
}
\value{
ggplot object with faceted visualization
}
\description{
Visualize the simulated moving circles patterns from simulate_moving_circles
}
\examples{
\donttest{
# Generate and visualize patterns
sim_data <- simulate_moving_circles(
  radius_seq = 6:14,
  n_steps = 10
)
plot_grid <- visualize_moving_circles(sim_data)
print(plot_grid)
}
}
