% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.DPP.R
\name{power.DPP}
\alias{power.DPP}
\title{Power Calculation for Bayesian Hybrid Design}
\usage{
power.DPP(
  pt,
  nt,
  pc,
  nc,
  pc.calib,
  pch,
  nche,
  nch,
  alpha = 0.1,
  tau = NULL,
  a0c = 0.001,
  b0c = 0.001,
  a0t = 0.001,
  b0t = 0.001,
  delta_threshold = 0.1,
  method = "Empirical Bayes",
  theta = 0.5,
  eta = 1,
  datamat = NULL,
  w0 = NULL,
  nsim = 1e+05,
  seed = NULL
)
}
\arguments{
\item{pt, pc}{Numerics. The response rates for the experimental and control
arms, respectively.}

\item{nt, nc}{Integers. The sample sizes for the experimental and control
arms, respectively.}

\item{pc.calib}{A scalar numeric. The control response rate assumed for
calibrating the type I error threshold, \code{tau}. Often \code{pc.calib = pch}.}

\item{pch, nch}{Numeric and integer. The response rate and sample size of the
historical control arm.}

\item{nche}{An integer. The effective number of subjects to be borrowed,
used for calculating the global borrowing weight.}

\item{alpha}{A scalar numeric. The one-sided Type I error rate, used for
calibration if \code{tau} is not provided.}

\item{tau}{(Optional) A scalar numeric. The pre-calibrated threshold for
statistical significance. If \code{NULL}, it will be calculated internally.}

\item{a0c, b0c, a0t, b0t}{Numerics. Hyperparameters for the Beta priors on the
response rates.}

\item{delta_threshold}{A scalar numeric. The similarity threshold for borrowing.}

\item{method}{A string specifying the dynamic borrowing method.}

\item{theta, eta}{Numerics. Additional parameters for certain borrowing methods.}

\item{datamat}{(Optional) A matrix with \code{nsim} rows and 2 columns
(experimental, control) of pre-simulated response counts.}

\item{w0}{(Optional) A scalar numeric. A fixed borrowing weight to override
the dynamic calculation.}

\item{nsim}{An integer. The number of simulations to run.}

\item{seed}{An integer. A seed for the random number generator. Default NULL.}
}
\value{
A large list containing the power, the calibrated \code{tau}, all input
parameters, and detailed simulation results such as:
\describe{
\item{power}{The calculated statistical power.}
\item{tau}{The calibrated significance threshold.}
\item{pc.PMD, pc.sd.PMD}{The mean and standard deviation of the posterior
mean difference between the hybrid and concurrent controls.}
\item{delta.bound}{The minimum detectable difference in response rates.}
\item{phat_pt_larger_pc_all}{A vector of posterior probabilities
\code{P(pt > pc | data)} for each of the \code{nsim} simulations.}
\item{mean_hca, mean_c}{Vectors of the posterior means for the hybrid
and concurrent control arms for each simulation.}
\item{simulated.data}{A matrix of the simulated response counts used.}
\item{w}{A vector of the final borrowing weights used in each simulation.}
\item{...}{and all input parameters.}
}
}
\description{
Calculates statistical power and other design parameters for a Bayesian
Hybrid Design using a dynamic power prior approach, based on simulations.
}
\examples{
\donttest{
o <- power.DPP(pt=0.5, nt=40, pc=0.3, nc=40, pc.calib = 0.3, pch=0.3,
               nche=40, nch=180, alpha=0.1, nsim = 1000, seed=2000) # nsim is reduced
}
}
