% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Frequentist.Analysis.R
\name{Frequentist.Analysis}
\alias{Frequentist.Analysis}
\title{Statistical Analysis Using Frequentist Method}
\usage{
Frequentist.Analysis(Yt = 20, nt = 40, Yc = 12, nc = 40, conflev = 0.8)
}
\arguments{
\item{Yt}{A scalar. The number of responses in the experimental arm.}

\item{nt}{A scalar. The number of subjects in the experimental arm.}

\item{Yc}{A scalar. The number of responses in the control arm.}

\item{nc}{A scalar. The number of subjects in the control arm.}

\item{conflev}{A scalar. The desired confidence level for the confidence intervals.}
}
\value{
An object of class \code{list} with the following values:
\itemize{
\item pt: The response rate of the experimental arm.
\item pc: The response rate of the control arm.
\item delta: The difference in response rates (pt - pc).
\item exactCI.c: A vector containing the Clopper-Pearson confidence
interval for the control arm.
\item exactCI.t: A vector containing the Clopper-Pearson confidence
interval for the experimental arm.
\item p.fisher: A one-sided p-value from Fisher's exact test, testing
the alternative hypothesis that the experimental response rate is greater
than the control response rate.
}
}
\description{
Performs a frequentist analysis of a two-arm study using current data only.
}
\examples{
Frequentist.Analysis(Yt=18, nt=40, Yc=13, nc=40, conflev=0.8)

}
