# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

abind <- function(x, y) {
    .Call(`_BayesMallows_abind`, x, y)
}

all_topological_sorts <- function(prefs, n_items, maxit, save) {
    .Call(`_BayesMallows_all_topological_sorts`, prefs, n_items, maxit, save)
}

#' Asymptotic Approximation of Partition Function
#'
#' Compute the asymptotic approximation of the logarithm of the partition function,
#' using the iteration algorithm of \insertCite{mukherjee2016;textual}{BayesMallows}.
#'
#' @param alpha_vector A numeric vector of alpha values.
#' @param n_items Integer specifying the number of items.
#' @param metric One of \code{"footrule"} and \code{"spearman"}.
#' @param K Integer.
#' @param n_iterations Integer specifying the number of iterations.
#' @param tol Stopping criterion for algorithm. The previous matrix is subtracted
#' from the updated, and if the maximum absolute relative difference is below \code{tol},
#' the iteration stops.
#'
#' @return A vector, containing the partition function at each value of alpha.
#' @keywords internal
#'
#' @references \insertAllCited{}
#'
asymptotic_partition_function <- function(alpha_vector, n_items, metric, K, n_iterations = 1000L, tol = 1e-9) {
    .Call(`_BayesMallows_asymptotic_partition_function`, alpha_vector, n_items, metric, K, n_iterations, tol)
}

get_rank_distance <- function(rankings, rho, metric) {
    .Call(`_BayesMallows_get_rank_distance`, rankings, rho, metric)
}

compute_importance_sampling_estimate <- function(alpha_vector, n_items, metric = "footrule", nmc = 1e4L) {
    .Call(`_BayesMallows_compute_importance_sampling_estimate`, alpha_vector, n_items, metric, nmc)
}

get_expected_distance <- function(alpha, n_items, metric, pfun_values) {
    .Call(`_BayesMallows_get_expected_distance`, alpha, n_items, metric, pfun_values)
}

get_partition_function <- function(alpha, n_items, metric, pfun_values) {
    .Call(`_BayesMallows_get_partition_function`, alpha, n_items, metric, pfun_values)
}

#' Sample from the Mallows distribution.
#'
#' Sample from the Mallows distribution with arbitrary distance metric using
#' a Metropolis-Hastings algorithm.
#'
#' @param rho0 Vector specifying the latent consensus ranking.
#' @param alpha0 Scalar specifying the scale parameter.
#' @param n_samples Integer specifying the number of random samples to generate.
#' @param burnin Integer specifying the number of iterations to discard as burn-in.
#' @param thinning Integer specifying the number of MCMC iterations to perform
#' between each time a random rank vector is sampled.
#' @param leap_size Integer specifying the step size of the leap-and-shift proposal distribution.
#' @param metric Character string specifying the distance measure to use. Available
#' options are \code{"footrule"} (default), \code{"spearman"}, \code{"cayley"}, \code{"hamming"},
#' \code{"kendall"}, and \code{"ulam"}.
#'
#' @keywords internal
#'
#' @references \insertAllCited{}
#'
rmallows <- function(rho0, alpha0, n_samples, burnin, thinning, leap_size = 1L, metric = "footrule") {
    .Call(`_BayesMallows_rmallows`, rho0, alpha0, n_samples, burnin, thinning, leap_size, metric)
}

run_mcmc <- function(data, model_options, compute_options, priors, initial_values, pfun_values, pfun_estimate, progress_report) {
    .Call(`_BayesMallows_run_mcmc`, data, model_options, compute_options, priors, initial_values, pfun_values, pfun_estimate, progress_report)
}

run_smc <- function(data, new_data, model_options, smc_options, compute_options, priors, initial_values, pfun_values, pfun_estimate) {
    .Call(`_BayesMallows_run_smc`, data, new_data, model_options, smc_options, compute_options, priors, initial_values, pfun_values, pfun_estimate)
}

