% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mains.R
\name{simulate_oc}
\alias{simulate_oc}
\title{Compute operating characteristics at the optimal boundary}
\usage{
simulate_oc(object, p, endpoint, seed = NULL)
}
\arguments{
\item{object}{the object returned by BOP2FE_xx}

\item{p}{a single vector or a list of vector for which the operating characteristics is desired.}

\item{endpoint}{the type of endpoint. Possible options are 'binary', 'nested', 'coprimary', and 'joint'.}

\item{seed}{for reproducibility}
}
\value{
\code{simulate_oc()} returns a data frame with the optimal pars and boundary from the given object as well 
as the operating characteristics. If a single p vector is supplied the result will be a data frame 
with a single row. If multiple p vectors are supplied the data frame will be have multiple rows each 
corresponding to the p vectors in the order of their specification
}
\description{
After identifying the optimal boundary that controls the Type I error rate 
less than or equal to 0.1 under H0 and maximize the power under H1, it might
be of interest to compute the operating characteristics of the optimal boundary 
under a different H1 values. This function accepts a single or multiple values of 
additional H1 values and compute the operating characteristics for each of them.
}
\examples{
test_nested <- BOP2FE_nested(
 H0=c(0.15,0.15, 0.70), 
 H1= c(0.25,0.25, 0.50),
 n = c(10, 5, 5),
 nsim = 1000, t1e = 0.1, method = "power",
 lambda1 = 0, lambda2 = 1, grid1 = 11,
 gamma1 = 0, gamma2 = 1, grid2 = 11,
 eta1 = 0, eta2 = 3, grid3 = 31,
 seed = 123
)

# Compute operating characteristics for a single p vector 
simulate_oc(test_nested, p=c(0.30,0.30,0.40), 
             endpoint = 'nested', seed=123)

# Compute operating characteristics for multiple p vector
 simulate_oc(test_nested, p=list(c(0.30,0.30,0.40),c(0.35,0.35,0.30)), 
             endpoint = 'nested', seed=123)


}
