% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_scrape_days_acb.R
\name{do_scrape_days_acb}
\alias{do_scrape_days_acb}
\title{ACB day game codes}
\usage{
do_scrape_days_acb(season, analyst_name, verbose, num_days, edition_id)
}
\arguments{
\item{season}{String with the starting year of the season. For example, "2024"
refers to the 2024-2025 season.}

\item{analyst_name}{Name to identify the user when doing web scraping. 
This is a polite way to do web scraping and certify that the user 
is working as transparently as possible with a research purpose.}

\item{verbose}{Should R report information on progress? TRUE or FALSE.}

\item{num_days}{Number of days to obtain.}

\item{edition_id}{Identifier of the league edition. For 2024 is 975
and for 2025 is 979. For coming seasons, check it at the ACB website, such as
\url{https://acb.com/calendario/index/temporada_id/2025} and click on any of
the days to see which url appears.}
}
\value{
A data frame with two columns, one with the days and the other with the game codes.
}
\description{
Obtain the game codes of any regular season day from any ACB season. 
These game codes will be used to define the target url from which collecting 
the shooting data of every game.
}
\note{
Before starting the web scraping, we must visit 
\url{https://www.acb.com/robots.txt} to check for permissions.
}
\examples{
\dontrun{
data_days <- do_scrape_days_acb("2024", "analyst_name", TRUE, 2, 975)
}

}
\seealso{
\code{\link{do_scrape_shots_acb}}
}
\author{
Guillermo Vinue
}
