% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumry.regsubsets.R
\name{sumry.regsubsets}
\alias{sumry.regsubsets}
\title{Summary for Subset Selection (\code{regsubsets}) Objects}
\usage{
\method{sumry}{regsubsets}(x, ...)
}
\arguments{
\item{x}{An object of class \code{regsubsets}.}

\item{...}{Additional arguments (not currently used).}
}
\value{
Returns a matrix containing a summary table for the best subsets analysis. Each row summarizes a model showing: the number of predictors, \code{k}, used; "which best" that model is for that \code{k}; performance statistics (see above); and a series of columns with asterisks indicating the specific predictors included in the model.
}
\description{
Generates a BAQM summary for objects of class \code{regsubsets} (from the \code{leaps} package), showing model selection statistics for best subsets, including R-squared, adjusted R-squared, standard error of estimate, Mallows' Cp, and AIC.
}
\details{
The function formats a table summarizing the best models selected, including the number of predictors, R-squared, adjusted R-squared, standard error of estimate (SEE), Mallows' Cp, and included variables. It is first converted to a summary.regsubsets with \code{summary()}. If not, the object is returned unmodified.
}
\examples{

fit <- leaps::regsubsets(Fertility ~ ., data = swiss, nbest = 3)
sumry(fit)

}
\seealso{
\code{\link[leaps]{regsubsets}},  \code{\link{print.sumry.regsubsets}}
}
