% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.sumry.regsubsets.R
\name{print.sumry.regsubsets}
\alias{print.sumry.regsubsets}
\title{Print Method for Best Subset Selection (\code{regsubsets}) Objects}
\usage{
\method{print}{sumry.regsubsets}(x, ...)
}
\arguments{
\item{x}{An object of class \code{summary.regsubsets} or \code{regsubsets}.}

\item{...}{Additional arguments (not currently used).}
}
\value{
Invisibly return the object printed.
}
\description{
Prints a summary for objects of class \code{summary.regsubsets} or \code{regsubsets} (from the \code{leaps} package), showing model selection statistics for best subsets, including R-squared, adjusted R-squared, standard error of estimate, Mallows' Cp, and AIC.
}
\details{
The function prints the model call and a table summarizing the best models selected, including the number of predictors, R-squared, adjusted R-squared, standard error of estimate (SEE), Mallows' Cp, and included variables.
If the input is a \code{regsubsets} object, it is converted with \code{sumry()}. If not, the object is returned unmodified.
}
\examples{

fit <- leaps::regsubsets(Fertility ~ ., data = swiss, nbest = 3)
print(sumry(fit))

}
\seealso{
\code{\link[leaps]{regsubsets}}, \code{\link{sumry.regsubsets}}
}
