% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoScore_Ordinal.R
\name{AutoScore_fine_tuning_Ordinal}
\alias{AutoScore_fine_tuning_Ordinal}
\title{AutoScore STEP(iv) for ordinal outcomes: Fine-tune the score by
  revising \code{cut_vec} with domain knowledge (AutoScore Module 5)}
\usage{
AutoScore_fine_tuning_Ordinal(
  train_set,
  validation_set,
  final_variables,
  link = "logit",
  cut_vec,
  max_score = 100,
  n_boot = 100,
  report_cindex = FALSE
)
}
\arguments{
\item{train_set}{A processed \code{data.frame} that contains data to be analyzed, for training.}

\item{validation_set}{A processed \code{data.frame} that contains data for validation purpose.}

\item{final_variables}{A vector containing the list of selected variables,
selected from Step(ii) \code{\link{AutoScore_parsimony_Ordinal}}.}

\item{link}{The link function used to model ordinal outcomes. Default is
\code{"logit"} for proportional odds model. Other options are
\code{"cloglog"} (proportional hazards model) and \code{"probit"}.}

\item{cut_vec}{Generated from STEP(iii) \code{\link{AutoScore_weighting_Ordinal}}.}

\item{max_score}{Maximum total score (Default: 100).}

\item{n_boot}{Number of bootstrap cycles to compute 95\% CI for performance
metrics.}

\item{report_cindex}{Whether to report generalized c-index for model
evaluation (Default:FALSE for faster evaluation).}
}
\value{
Generated final table of scoring model for downstream testing
}
\description{
Domain knowledge is essential in guiding risk model development.
 For continuous variables, the variable transformation is a data-driven process (based on "quantile" or "kmeans" ).
 In this step, the automatically generated cutoff values for each continuous variable can be fine-tuned
 by combining, rounding, and adjusting according to the standard clinical norm.  Revised \code{cut_vec} will be input with domain knowledge to
update scoring table. User can choose any cut-off values/any number of categories. Then final Scoring table will be generated. Run \code{vignette("Guide_book", package = "AutoScore")} to see the guidebook or vignette.
}
\examples{
## Please see the guidebook or vignettes
}
\references{
\itemize{
 \item{Saffari SE, Ning Y, Feng X, Chakraborty B, Volovici V, Vaughan R, Ong
       ME, Liu N, AutoScore-Ordinal: An interpretable machine learning framework for
       generating scoring models for ordinal outcomes, arXiv:2202.08407}
}
}
\seealso{
\code{\link{AutoScore_rank_Ordinal}},
  \code{\link{AutoScore_parsimony_Ordinal}},
  \code{\link{AutoScore_weighting_Ordinal}},
  \code{\link{AutoScore_testing_Ordinal}}.
}
