% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_argentine_deputies.R
\name{get_argentine_deputies}
\alias{get_argentine_deputies}
\title{Get Argentine Deputies (Diputados)}
\usage{
get_argentine_deputies()
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{id}: Unique identifier for the deputy.
  \item \code{nombre}: First name of the deputy.
  \item \code{apellido}: Last name of the deputy.
  \item \code{genero}: Gender of the deputy.
  \item \code{provincia}: Province represented.
  \item \code{inicio}: Start date of the mandate period (Date).
  \item \code{fin}: End date of the mandate period (Date).
}
}
\description{
This function retrieves a list of Argentine deputies from the public API endpoint
`https://api.argentinadatos.com/v1/diputados/diputados`. It includes basic information
and the official mandate period of each deputy.
}
\details{
The data is returned in descending order of the start date (\code{inicio}), showing the
most recent mandates first.
}
\note{
Requires internet connection. If `inicio` or `fin` dates are malformed, parsing may fail.
}
\examples{
\dontrun{
deputies <- get_argentine_deputies()
head(deputies)

# Filter currently active deputies
active <- dplyr::filter(deputies, Sys.Date() <= fin)
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{arrange}}
}
