% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateApotc.R
\name{updateApotc}
\alias{updateApotc}
\title{Update APackOfTheClones objects to the latest format}
\usage{
updateApotc(x, verbose = TRUE, ...)
}
\arguments{
\item{x}{An object to update. Supported types are Seurat objects and ggplot
objects generated by APackOfTheClones.}

\item{verbose}{Logical. Whether to print messages about the update process.
Default is TRUE.}

\item{...}{Additional arguments passed to methods. Currently unused.}
}
\value{
The updated object, or the original object if no update is required.
}
\description{
This generic function updates objects created by APackOfTheClones to the
latest format or structure required by the package. It supports Seurat
objects and ggplot objects generated by APackOfTheClones functions.

The current possible changes made by the function are:
\itemize{
\item when called on ggplots generated by \code{\link[=vizAPOTC]{vizAPOTC()}} / \code{\link[=APOTCPlot]{APOTCPlot()}}, layer
names will be made unique.
}
}
\examples{
data("combined_pbmc")
apotc_plot <- vizAPOTC(combined_pbmc)
apotc_plot <- updateApotc(apotc_plot, verbose = TRUE)
apotc_plot

}
