% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showCloneHighlight.R
\name{showCloneHighlight}
\alias{showCloneHighlight}
\title{Highlight specific clones on an APackOfTheClones ggplot}
\usage{
showCloneHighlight(
  apotc_ggplot,
  clonotype,
  color_each = TRUE,
  default_color = "#808080",
  scale_bg = 1,
  fill_legend = TRUE
)
}
\arguments{
\item{apotc_ggplot}{A ggplot object that is the output of \code{\link[=APOTCPlot]{APOTCPlot()}} or
\code{\link[=vizAPOTC]{vizAPOTC()}} of an APackOfTheClones plot to be highlighted on.}

\item{clonotype}{character vector of the sequence(s) to highlight. Note
that it must be of the clonecall of the code that created the plot. A
warning will be shown if any of the sequences are not present.}

\item{color_each}{Either a logical of length 1, or a character(s). It is
\code{TRUE} by default, which assigns a unique default ggplot color to each
highlighted clone. If \code{FALSE}, each highlighted clone will retain its
current color and no legend based on color is shown. A possible application
here is to simply gauge the distribution of any shared clone.
It can also indicate the uniform color of each highlighted clone: if it is
a character of length 1, all highlighted clones will be of that color.
Else it must be a character vector of the same length as
\code{clonotype}, with each color corresponding to the clone. Here is a suitable
place to use any palette function from the many other CRAN palette packages
such as \code{"viridis"} or \code{"RColorBrewer"}. Note that currently, the user must
ensure \code{clonotype} contains only unique characters.}

\item{default_color}{A character of length 1 or \code{NULL} indicating the color
of non-highlighted clones. If \code{NULL}, all un-highlighted sequences will
retain their original color in \code{sc.data}. Else, if it is a character, it
should be a valid color that all un-highlighted clones are. Defaults to the
hex code for gray.}

\item{scale_bg}{A positive numeric. Scales the brightness value of each color
of the non-highlighted clones by itself as a scaling factor. Defaults to 1
which will not alter the current brightness. Note that if
\code{color_each = FALSE} and \code{default_color = NULL}, this is equivalent to not
highlighting any clones - in this case, it may be useful to alter \code{scale_bg}
slightly so that the non-highlighted clones are darkened/brightened.}

\item{fill_legend}{logical indicating whether a ggplot legend of the "fill"
of each clonotype should be displayed.}
}
\value{
A ggplot object with the data modified to the highlighted colors
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This is an analogue for \code{scRepertoire::highlightClones} that can highlight
certain clonotypes on an APackOfTheClones clonal expansion plot. For most
combinations of the arguments, there will be a ggplot fill legend on the
right side that correspond to each (existing) clonotype.
}
\details{
Under the hood, this function simply mutates the plotting data.frame under
\verb{$data} in the ggplot object, and operates on a column named \code{color}.

Note that if \code{color_each = FALSE} and \code{default_color = NULL}, this is
equivalent to simply not highlighting anything and a warning will be shown.
}
\examples{
library(dplyr)
data("combined_pbmc")

# piping the plot can be nice to read syntactically -
# By default, assigns unique colors to highlights and everything else is gray
vizAPOTC(combined_pbmc, clonecall = "aa", verbose = FALSE) \%>\%
    showCloneHighlight("CASLSGSARQLTF_CASSSTVAGEQYF")

# one useful application is to highlight shared clones - beware that the
# clonotype sequences may get extremely long in the legend
shared_aa_clones <- names(getSharedClones(combined_pbmc, clonecall = "aa"))
vizAPOTC(combined_pbmc, clonecall = "aa", verbose = FALSE) \%>\%
    showCloneHighlight(shared_aa_clones)

}
