# Produce modified ggplot object of an APackOfTheClones plot with an extra slot
# hack fix - the clone size slot stores the autogenerated legend sizes
ApotcGGPlot <- function(ggplot_obj, apotc_obj) {
    apotc_obj@clusters <- list()
    apotc_obj@clone_sizes <- list(estimate_legend_sizes(apotc_obj))
    ggplot_obj$APackOfTheClones <- apotc_obj
    ggplot_obj
}

is_an_apotc_ggplot <- function(x, detail = NA) {
    is_apotc <- inherits(x, "ggplot") &&
        !is.null(x$APackOfTheClones)
    if (is.na(detail)) {
        return(is_apotc)
    } else {
        undetailed <- is_undetailed(x)
        return(is_apotc && undetailed != detail)
    }
}
on_failure(is_an_apotc_ggplot) <- function(call, env) {
    if (is.na(call$detail)) {
        return(paste0(deparse(call$x), " is not an APackOfTheClones ggplot"))
    }
    paste0(
        deparse(call$x),
        " is not an APackOfTheClones ggplot with detail = ",
        call$detail
    )
}

# getter
get_apotcdata <- function(apotc_ggplot_obj) {
    apotc_ggplot_obj$APackOfTheClones
}

# based on the hack fix - get the estimated legend sizes in a apot ggplot
get_estimated_legend_sizes <- function(apotc_ggplot_obj) {
    get_raw_clone_sizes(get_apotcdata(apotc_ggplot_obj))[[1]]
}
