% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_hcd_mean.R
\name{calc_hcd_mean}
\alias{calc_hcd_mean}
\title{Calculate Mean Perceived Health Care Discrimination Score}
\usage{
calc_hcd_mean(survey_df)
}
\arguments{
\item{survey_df}{A data frame containing survey data with at least three columns:
`person_id`, `question_concept_id`, and `answer_concept_id`.}
}
\value{
A data frame with two columns: `person_id` and `hcd_mean`, where `hcd_mean`
represents the mean level of perceived discrimination in health care. Participants who did not respond
to all 7 items will have an NA value for `hcd_mean`.
}
\description{
This function creates a numeric score (range 1-5) that reflects the mean level of perceived discrimination in
health care based on responses to seven specific survey items. Higher scores indicate greater perceived
discrimination in health care.
}
\examples{
# Create a sample survey data frame
survey_df <- data.frame(
  person_id = rep(1:3, each = 7),
  question_concept_id = rep(c(40192383, 40192394, 40192423, 40192425,
                              40192497, 40192503, 40192505), times = 3),
  answer_concept_id = sample(c(40192465, 40192481, 40192429, 40192382, 40192515),
                             21, replace = TRUE)
)

# Compute mean perceived health care discrimination scores
hcd_mean_scores <- calc_hcd_mean(survey_df)
head(hcd_mean_scores)

}
