% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_ph.R
\docType{data}
\name{vars_ph_p_dhx_birthweight}
\alias{vars_ph_p_dhx_birthweight}
\alias{compute_ph_p_dhx_birthweight}
\title{Compute "Developmental History [Parent]: Youth birth weight"}
\format{
vars_ph_p_dhx_birthweight is a character vector of all column names
used to compute summary score of \code{ph_p_dhx_birthweight}.
}
\usage{
vars_ph_p_dhx_birthweight

compute_ph_p_dhx_birthweight(
  data,
  name = "ph_p_dhx_birthweight",
  combine = TRUE
)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.
NOTE: Only baseline and year 4 data has been used for this summary score.}

\item{name}{character, Name of the new column to be created. Default is
the name in description, but users can change it.}

\item{combine}{logical, If \code{TRUE}, the summary score will be appended to
the input data frame. If \code{FALSE}, the summary score will be returned as a
separate data frame.}
}
\value{
tbl. The input data frame with the summary score appended as
a new column.
}
\description{
Computes the summary score \code{ph_p_dhx_birthweight}
Developmental History [Parent]: Youth birth weight
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{ph_p_dhx_002__01}
\item \code{ph_p_dhx_002__02}
}
\item \emph{Excluded values:}
\itemize{
\item 999
\item any value less than 0
}
\item \emph{Notes:}
\itemize{
\item Computed using only baseline (\verb{ses-00A}) and four-year (\verb{ses-04A}) data
\item The following transformations were made prior to computing the score:
\itemize{
\item if \code{ph_p_dhx_002__01} < 2, set it to 2
\item if \code{ph_p_dhx_002__01} > 15, set it to 15
\item if \code{ph_p_dhx_002__02} > 15 / 16, set it to 15 / 16
}
\item The following decisions were made based on discordance between baseline
and four-year data:
\itemize{
\item if discordance is <= 1, take baseline weight
\item if discordance is > 1 and baseline weight is > 4, take baseline weight
\item else if discordance is > 1, take four-year weight
\item else if baseline weight is missing, take four-year weight
\item else, take baseline weight
}
}
}
}
\keyword{datasets}
