# MicroDatosEs

[![R build status](https://github.com/rOpenSpain/MicroDatosEs/workflows/R-CMD-check/badge.svg)](https://github.com/rOpenSpain/MicroDatosEs/actions/?workflow=R-CMD-check)

`MicroDatosEs` is an R package to process [microdata](https://en.wikipedia.org/wiki/Microdata_(statistics)) provided by Spanish statistical agencies (mostly, [INE](http://www.ine.es)).

It is a package in continuous process of expansion: it is expanding the number of microdata sets it is able to process and it has to adapt to format changes in new versions of the datasets.

It is intended mostly for microdata which is generated periodically with the same format (e.g., EPA, which is is generated each quarter).

## Covered datasets

* **EPA** (Encuesta de población activa)
* **Census (2011)**
* **EES** (Encuesta de estructura salarial)
* **Mortality** (Annual deaths in Spain): unfortunately, public microdata does not include the cause of death.
* **EPF** (Encuesta de presupuestos familiares)
* **Padrón**

## Use cases and examples

* [Un paseo por el paquete MicroDatosEs (y la EPA, de nuevo)](https://www.datanalytics.com/2012/08/06/un-paseo-por-el-paquete-microdatoses-y-la-epa-de-nuevo/)


## Help wanted

You can help to improve this package in several ways: expanding its functionality, making it easier to use, making it better known. In particular, if you have a good use case, contact the maintainers and we will include a link to it. You can submit requests via Github's issues facility; they are most welcome.
