## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

options(gtsummary.print_engine = "gt")

## ----setup--------------------------------------------------------------------
# library(sumExtras)
# library(gtsummary)
# library(dplyr)
# 
# use_jama_theme()

## ----setup2-------------------------------------------------------------------
library(sumExtras)
library(gtsummary)
library(dplyr)

use_jama_theme()

## -----------------------------------------------------------------------------
# Without p-values
trial |>
  tbl_summary(by = trt) |>
  extras(pval = FALSE)

## -----------------------------------------------------------------------------
# Overall column last instead of first
trial |>
  tbl_summary(by = trt) |>
  extras(last = TRUE)

## -----------------------------------------------------------------------------
# Custom header text
trial |>
  tbl_summary(by = trt) |>
  extras(header = "Variable")

## -----------------------------------------------------------------------------
my_args <- list(pval = TRUE, overall = TRUE, last = TRUE)

trial |>
  select(age, grade, stage, trt) |>
  tbl_summary(by = trt) |>
  extras(.args = my_args)

## -----------------------------------------------------------------------------
# Regression tables work too
glm(response ~ age + grade, data = trial, family = binomial) |>
  tbl_regression(exponentiate = TRUE) |>
  extras()

## ----eval=FALSE---------------------------------------------------------------
# t1 <- trial |>
#   tbl_summary(by = trt, include = c(age, grade)) |>
#   extras()
# 
# t2 <- trial |>
#   tbl_summary(by = trt, include = c(marker, stage)) |>
#   extras()
# 
# tbl_merge(list(t1, t2), tab_spanner = c("**Set A**", "**Set B**"))

## -----------------------------------------------------------------------------
demo_trial <- trial |>
  mutate(
    age = if_else(trt == "Drug B", 0, age),
    marker = if_else(trt == "Drug A", NA, marker)
  ) |>
  select(trt, age, marker)

## ----clean-comparison-without, eval=FALSE-------------------------------------
# demo_trial |>
#   tbl_summary(by = trt)

## ----clean-comparison-with, eval=FALSE----------------------------------------
# demo_trial |>
#   tbl_summary(by = trt) |>
#   clean_table()

## ----build-clean-comparison, echo=FALSE---------------------------------------
table_without_clean <- demo_trial |>
  tbl_summary(by = trt)

table_with_clean <- demo_trial |>
  tbl_summary(by = trt) |>
  clean_table()

## ----render-without-clean, echo=FALSE-----------------------------------------
table_without_clean

## ----render-with-clean, echo=FALSE--------------------------------------------
table_with_clean

## -----------------------------------------------------------------------------
dictionary <- tibble::tribble(
  ~variable,    ~description,
  "trt",        "Chemotherapy Treatment",
  "age",        "Age at Enrollment (years)",
  "marker",     "Marker Level (ng/mL)",
  "stage",      "T Stage",
  "grade",      "Tumor Grade"
)

trial |>
  tbl_summary(by = trt, include = c(age, grade, marker)) |>
  add_auto_labels(dictionary = dictionary) |>
  extras()

## ----eval=FALSE---------------------------------------------------------------
# tbl_summary(by = ...) |>
#   extras() |> # always first
#   add_variable_group_header() |> # after extras()
#   add_group_styling() |> # format group headers
#   add_group_colors() # must be last (converts to gt)

