/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractTriangPackMatrix;
import no.uib.cipr.matrix.BLASkernel;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;

public class UpperTriangPackMatrix
extends AbstractTriangPackMatrix {
    public UpperTriangPackMatrix(int n) {
        super(n, BLASkernel.UpLo.Upper, BLASkernel.Diag.NonUnit);
    }

    UpperTriangPackMatrix(int n, BLASkernel.Diag diag) {
        super(n, BLASkernel.UpLo.Upper, diag);
    }

    public UpperTriangPackMatrix(Matrix A) {
        this(A, true);
    }

    public UpperTriangPackMatrix(Matrix A, boolean deep) {
        super(A, deep, BLASkernel.UpLo.Upper, BLASkernel.Diag.NonUnit);
    }

    UpperTriangPackMatrix(Matrix A, boolean deep, BLASkernel.Diag diag) {
        super(A, deep, BLASkernel.UpLo.Upper, diag);
    }

    public void add(int row, int column, double value) {
        if (row > column) {
            throw new IllegalArgumentException("row > column");
        }
        int n = this.getIndex(row, column);
        this.data[n] = this.data[n] + value;
    }

    public void set(int row, int column, double value) {
        if (row > column) {
            throw new IllegalArgumentException("row > column");
        }
        this.data[this.getIndex((int)row, (int)column)] = value;
    }

    public double get(int row, int column) {
        if (row > column) {
            return 0.0;
        }
        return this.data[this.getIndex(row, column)];
    }

    int getIndex(int row, int column) {
        this.check(row, column);
        return row + (column + 1) * column / 2;
    }

    void copy(Matrix A) {
        for (MatrixEntry e : A) {
            if (e.row() > e.column()) continue;
            this.set(e.row(), e.column(), e.get());
        }
    }

    public UpperTriangPackMatrix copy() {
        return new UpperTriangPackMatrix(this);
    }
}

