/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.preorder;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeTraitProvider;
import dr.evomodel.treedatalikelihood.BeagleDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.preorder.AbstractBeagleGradientDelegate;

public abstract class AbstractBeagleBranchGradientDelegate
extends AbstractBeagleGradientDelegate {
    protected AbstractBeagleBranchGradientDelegate(String string, Tree tree, BeagleDataLikelihoodDelegate beagleDataLikelihoodDelegate) {
        super(string, tree, beagleDataLikelihoodDelegate);
    }

    protected abstract void cacheDifferentialMassMatrix(Tree var1, boolean var2);

    @Override
    protected int getGradientLength() {
        return this.tree.getNodeCount() - 1;
    }

    @Override
    protected void getNodeDerivatives(Tree tree, double[] dArray, double[] dArray2) {
        boolean bl;
        int[] nArray = new int[tree.getNodeCount() - 1];
        int[] nArray2 = new int[tree.getNodeCount() - 1];
        int[] nArray3 = new int[tree.getNodeCount() - 1];
        int[] nArray4 = new int[tree.getNodeCount() - 1];
        boolean bl2 = bl = !this.substitutionProcessKnown || dArray2 != null;
        if (bl) {
            this.cacheDifferentialMassMatrix(tree, dArray2 != null);
            this.substitutionProcessKnown = true;
        }
        int n = 0;
        for (int i = 0; i < tree.getNodeCount(); ++i) {
            if (tree.isRoot(tree.getNode(i))) continue;
            nArray[n] = this.getPostOrderPartialIndex(i);
            nArray2[n] = this.getPreOrderPartialIndex(i);
            nArray3[n] = this.getFirstDerivativeMatrixBufferIndex(i);
            nArray4[n] = this.getSecondDerivativeMatrixBufferIndex(i);
            ++n;
        }
        double[] dArray3 = dArray2 != null ? new double[dArray2.length] : null;
        this.beagle.calculateEdgeDifferentials(nArray, nArray2, nArray3, new int[]{0}, tree.getNodeCount() - 1, null, dArray, dArray3);
        if (dArray2 != null) {
            this.beagle.calculateEdgeDifferentials(nArray, nArray2, nArray4, new int[]{0}, tree.getNodeCount() - 1, null, dArray2, null);
            for (int i = 0; i < dArray2.length; ++i) {
                int n2 = i;
                dArray2[n2] = dArray2[n2] - dArray3[i];
            }
        }
    }

    private void checkReduction(double[] dArray) {
        for (double d : dArray) {
            int n;
            double d2;
            if (!Double.isNaN(d)) continue;
            double[] dArray2 = new double[this.patternCount * this.stateCount * this.categoryCount];
            double[] dArray3 = new double[this.patternCount * this.stateCount * this.categoryCount];
            double[] dArray4 = new double[this.patternCount * this.stateCount * this.categoryCount];
            double[] dArray5 = new double[this.stateCount * this.stateCount * this.categoryCount];
            this.beagle.getPartials(this.getPostOrderPartialIndex(0), -1, dArray2);
            this.beagle.getPartials(this.getPostOrderPartialIndex(this.tree.getRoot().getNumber()), -1, dArray3);
            this.beagle.getPartials(this.getPreOrderPartialIndex(0), -1, dArray4);
            this.beagle.getTransitionMatrix(this.getFirstDerivativeMatrixBufferIndex(0), dArray5);
            double[] dArray6 = new double[this.patternCount];
            double[] dArray7 = new double[this.patternCount];
            for (int i = 0; i < this.categoryCount; ++i) {
                double d3 = this.siteRateModel.getProportionForCategory(i);
                int n2 = 0;
                while (n2 < this.patternCount) {
                    double d4 = 0.0;
                    d2 = 0.0;
                    for (n = 0; n < this.stateCount; ++n) {
                        double d5 = 0.0;
                        for (int j = 0; j < this.stateCount; ++j) {
                            d5 += dArray5[this.stateCount * this.stateCount * i + this.stateCount * n + j] * dArray2[this.stateCount * this.patternCount * i + this.stateCount * n2 + j];
                        }
                        d4 += d5 * dArray4[this.stateCount * this.patternCount * i + this.stateCount * n2 + n];
                        d2 += dArray2[this.stateCount * this.patternCount * i + this.stateCount * n2 + n] * dArray4[this.stateCount * this.patternCount * i + this.stateCount * n2 + n];
                    }
                    int n3 = n2;
                    dArray6[n3] = dArray6[n3] + d3 * d4;
                    int n4 = n2++;
                    dArray7[n4] = dArray7[n4] + d3 * d2;
                }
            }
            double[] dArray8 = this.evolutionaryProcessDelegate.getRootStateFrequencies();
            double[] dArray9 = new double[this.patternCount];
            for (int i = 0; i < this.categoryCount; ++i) {
                double d6 = this.siteRateModel.getProportionForCategory(i);
                int n5 = 0;
                while (n5 < this.patternCount) {
                    d2 = 0.0;
                    for (n = 0; n < this.stateCount; ++n) {
                        d2 += dArray3[this.stateCount * this.patternCount * i + this.stateCount * n5 + n] * dArray8[n];
                    }
                    int n6 = n5++;
                    dArray9[n6] = dArray9[n6] + d2 * d6;
                }
            }
        }
    }

    @Override
    protected void constructTraits(TreeTraitProvider.Helper helper) {
        helper.addTrait(new TreeTrait.DA(){

            @Override
            public String getTraitName() {
                return AbstractBeagleBranchGradientDelegate.this.getGradientTraitName();
            }

            @Override
            public TreeTrait.Intent getIntent() {
                return TreeTrait.Intent.BRANCH;
            }

            @Override
            public double[] getTrait(Tree tree, NodeRef nodeRef) {
                return AbstractBeagleBranchGradientDelegate.this.getGradient(nodeRef);
            }
        });
        helper.addTrait(new TreeTrait.DA(){

            @Override
            public String getTraitName() {
                return AbstractBeagleBranchGradientDelegate.this.getHessianTraitName();
            }

            @Override
            public TreeTrait.Intent getIntent() {
                return TreeTrait.Intent.BRANCH;
            }

            @Override
            public double[] getTrait(Tree tree, NodeRef nodeRef) {
                return AbstractBeagleBranchGradientDelegate.this.getHessian(tree, nodeRef);
            }
        });
    }
}

