## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(MUGS)

## ----load_data----------------------------------------------------------------
# Load required data
data(S.1)
data(S.2)
data(U.1)
data(U.2)
data(X.group.source)
data(X.group.target)

## ----prepare_variables--------------------------------------------------------
# Set parameters
n1 <- 100
n2 <- 100
p <- 5

# Initial right embeddings
V.1 <- U.1
V.2 <- U.2

# Fix rownames to ensure alignment
n1.no <- n1 - 50  # if you know n.common = 50
rownames(U.1) <- as.character(seq_len(nrow(U.1)))  # "1" to "n1"
rownames(U.2) <- as.character(seq(from = n1.no + 1, length.out = nrow(U.2)))
rownames(S.1) <- rownames(U.1)
rownames(S.2) <- rownames(U.2)
rownames(V.1) <- rownames(U.1)
rownames(V.2) <- rownames(U.2)

# Extract names and find common codes
names.list.1 <- rownames(S.1)
names.list.2 <- rownames(S.2)
common_codes <- intersect(names.list.1, names.list.2)

# Check for overlap
if (length(common_codes) == 0) stop("Error: No common codes found between S.1 and S.2.")

# Create zeta.int
full.name.list <- c(names.list.1, names.list.2)
zeta.int <- matrix(0, length(full.name.list), p)
rownames(zeta.int) <- full.name.list

## ----run_function-------------------------------------------------------------
# Estimate code effects
CodeEff_Matrix.out <- CodeEff_Matrix(
  S.1=S.1,
  S.2=S.2,
  n1=n1,
  n2=n2,
  U.1=U.1,
  U.2=U.2,
  V.1=U.1,
  V.2=U.2,
  common_codes = common_codes,
  zeta.int = zeta.int,
  lambda=10,
  p=5
  )

## ----examine_output-----------------------------------------------------------
# View structure of the output
str(CodeEff_Matrix.out)

# Print specific components of the result
cat("\nEstimated Code Effects (zeta):\n")
print(CodeEff_Matrix.out$zeta[1:5, 1:3])  # Show the first 5 rows and 3 columns of zeta

cat("\nFrobenius Norm Difference (dif_F):\n")
print(CodeEff_Matrix.out$dif_F)

cat("\nUpdated Right Embeddings for Source Site (V.1.new):\n")
print(CodeEff_Matrix.out$V.1.new[1:5, 1:3])  # Show first 5 rows and 3 columns of V.1.new

cat("\nUpdated Right Embeddings for Target Site (V.2.new):\n")
print(CodeEff_Matrix.out$V.2.new[1:5, 1:3])  # Show first 5 rows and 3 columns of V.2.new

