/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.AbstractIterationMonitor;
import no.uib.cipr.matrix.sparse.IterativeSolverNotConvergedException;

public class DefaultIterationMonitor
extends AbstractIterationMonitor {
    double initR;
    double rtol;
    double atol;
    double dtol;
    int maxIter;

    public DefaultIterationMonitor(int maxIter, double rtol, double atol, double dtol) {
        this.maxIter = maxIter;
        this.rtol = rtol;
        this.atol = atol;
        this.dtol = dtol;
    }

    public DefaultIterationMonitor() {
        this.maxIter = 100000;
        this.rtol = 1.0E-5;
        this.atol = 1.0E-50;
        this.dtol = 100000.0;
    }

    public void setMaxIterations(int maxIter) {
        this.maxIter = maxIter;
    }

    public void setRelativeTolerance(double rtol) {
        this.rtol = rtol;
    }

    public void setAbsoluteTolerance(double atol) {
        this.atol = atol;
    }

    public void setDivergenceTolerance(double dtol) {
        this.dtol = dtol;
    }

    protected boolean convergedI(double r) throws IterativeSolverNotConvergedException {
        if (this.isFirst()) {
            this.initR = r;
        }
        if (r < Math.max(this.rtol * this.initR, this.atol)) {
            return true;
        }
        if (r > this.dtol * this.initR) {
            throw new IterativeSolverNotConvergedException(NotConvergedException.Reason.Divergence, this);
        }
        if (this.iter >= this.maxIter) {
            throw new IterativeSolverNotConvergedException(NotConvergedException.Reason.Iterations, this);
        }
        if (Double.isNaN(r)) {
            throw new IterativeSolverNotConvergedException(NotConvergedException.Reason.Divergence, this);
        }
        return false;
    }

    protected boolean convergedI(double r, Vector x) throws IterativeSolverNotConvergedException {
        return this.convergedI(r);
    }
}

