/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent.structure;

import dr.evolution.coalescent.structure.Event;
import dr.evolution.coalescent.structure.MetaPopulation;
import dr.evolution.coalescent.structure.StructuredIntervalList;
import dr.evolution.colouring.ColourChangeMatrix;
import dr.evolution.colouring.TreeColouring;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;

public class StructuredCoalescent {
    static double tinyTime = 1.0E-6;

    public double calculateLogLikelihood(TreeColouring treeColouring, StructuredIntervalList structuredIntervalList, ColourChangeMatrix colourChangeMatrix, MetaPopulation metaPopulation) {
        double d = 0.0;
        Tree tree = treeColouring.getTree();
        double d2 = 0.0;
        for (int i = 0; i < tree.getExternalNodeCount(); ++i) {
            NodeRef nodeRef = tree.getExternalNode(i);
            d += Math.log(colourChangeMatrix.getEquilibrium(treeColouring.getNodeColour(nodeRef)));
        }
        double d3 = 0.0;
        for (int i = 0; i < structuredIntervalList.getIntervalCount(); ++i) {
            double d4 = 0.0;
            double d5 = structuredIntervalList.getInterval(i);
            for (int j = 0; j < structuredIntervalList.getPopulationCount(); ++j) {
                int n = structuredIntervalList.getLineageCount(i, j);
                d4 += (double)(n * (n - 1)) / 2.0 * metaPopulation.getIntegral(d3, d3 + d5, j);
                d4 += -colourChangeMatrix.getBackwardRate(j, j) * (double)n * d5;
            }
            d2 += d4;
            double d6 = 0.0;
            Event event = structuredIntervalList.getEvent(i);
            d3 += d5;
            switch (event.getType()) {
                case COALESCENT: {
                    if (event.getAboveColour() != event.getBelowColour()) {
                        throw new Error("Coalescent event changes colour");
                    }
                    d6 = 1.0 / metaPopulation.getDemographic(d3 - tinyTime, event.getAboveColour());
                    break;
                }
                case MIGRATION: {
                    if (event.getAboveColour() == event.getBelowColour()) {
                        throw new Error("Colour-change event fails to change colour");
                    }
                    d6 = colourChangeMatrix.getBackwardRate(event.getBelowColour(), event.getAboveColour());
                    break;
                }
                case SAMPLE: {
                    d6 = 1.0;
                }
            }
            d += Math.log(d6) - d4;
        }
        return d;
    }
}

