package Tie::Toggle;
use strict;
use v5.10;

use parent qw( Tie::Cycle );
use vars qw( $VERSION );

$VERSION = '1.089';

sub TIESCALAR {
	my $class = shift;
	my $self = [ 0, 2, [ 0 == 1, 1 == 1] ];
	bless $self, $class;
	}

1;

__END__

=encoding utf8

=pod

=head1 NAME

Tie::Toggle - False and true, alternately, ad infinitum.

=head1 SYNOPSIS

	use Tie::Toggle;

	tie my $toggle, 'Tie::Toggle';

	foreach my $number ( 0 .. 10 ) {
		next unless $toggle;
		print $number, "\n";
		}

=head1 DESCRIPTION

You use C<Tie::Toggle> to go back and forth between false
and true over and over again. You don't have to worry about
any of this since the magic of tie does that for you by
using C<Tie::Cycle>.  Any time you access the value, it
flips.

You can also use C<Tie::FlipFlop> by Abigail to do the same
thing, but with any two values.

=head1 SOURCE AVAILABILITY

This source is in GitHub:

	https://github.com/briandfoy/tie-toggle

=head1 AUTHOR

brian d foy, C<< <briandfoy@pobox.com> >>.

=head1 COPYRIGHT AND LICENSE

Copyright © 2000-2025, brian d foy <briandfoy@pobox.com>. All rights reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the Artistic License 2.0.

=cut

