# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..10\n"; }
END {print "not ok 1\n" unless $loaded;}
use GH::MspTools qw(getMSPs);
$loaded = 1;
print "ok 1\n";

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

use lib "../../Msp/blib/lib";
use lib "../../Msp/blib/arch";

use GH::Msp;

sub Not {
  print "not ";
}

sub Ok {
  my($i) = @_;
  print "ok $i\n";
}
  
$i = 2;

$s1 = <<MOOSE;
TCCCGGATCTGATTCTGACACCTCGACTCGTCGGAACGACGCCCTTGCATCAGCCAGTACGGTTC
CAGATGTGGCGCGCAAGTGCAGCACAGTGTGGACCGGAGCGCTAATCCTCAAGAGCTCACTGTTC
CCAGCCAAGTTTCATTTGACGGACGGAGATACGGATATTGTGGAGTCGCTGATGCGCGATGAGGA
GGGCAAGCACAACCTACGTATCACCCAGCGACTGCGTCTGGATCCGCCCAAGCTGGACGACGTGC
AAAAACGTATTGCATCCTCATCGTCGCACGCCATTTTCATGGGTCTGGCAGGGTCCACAAACGAC
ACCAATTGCGACGATGCCAGCGTGCAGACGCGACCACTAAGAAACTTGGTTTCCTATCTTAAGCA
GAAGGAGGCGGCTGGCGTGATCTCGCTGCTTAACAAGGAGACGGAGGCAACTGGGGTGCTGTACG
CCTTCCCCCCCTGCGACTTTTCCACAGAGCTGCTAAAGCGCACTTGTCACAGTCTGACGGAGGAG
GGCCTGAAGGAGGATCACCTGGTGATTGTGGTGGTGCGCGGCGGAACGGCCTGAGCTGGAGCGGC
TGGCGACGGTGGGGATGGGAGGACAAACTGTAGTTCCGCAGCTAGTCGTTGGATCGCACTTTGCG
CAGCGATCCGCGGTTAAACTTGCAGATGGACTCCAGAAGAGCGGAGCGTGTTGGCTCGTCGCCAT
CACCGCCCTCCGCATCCTCAGACAGCATGTTCGGTGTGGAGGACTGCCGTTCCACCGGTGCGCCA
GTCGTCGACGGCAATTCCTGCTGATATATGCTGCCCAAGTGTGGCCCCGGAGTGAGCGGCGGTGC
TGAAAGGAAGACGAGATCGAAGTGAGTCATTTGGTGGGCTCCTCGGGTGTGCTGTCGGAGCGGTT
GAAGGAGTCGGTCCCACATAACTCGCCAACCACCGTGGTGCTTGAGGAAGCTGCTGCTGCAGTCG
CAGCCACAAGCGACAAGCGTCCATTGTTTGTTTGGATTGAACTTTGCTGCTTTAGCTTCGACTGT
TTGTGCTC
MOOSE

$s2 = <<MOOSE;
GGAAGACGAGATCGGAAGTGAGTCATTGTGGTGGGCTCCTCGGGTGTGCTGTCGGAGCGGTTGAA
GGAGTCGGTCCCACATAACTCGCCAACCACCGTGGTGCTTGAGGAAGCTGCTGCTGCAGTCGCAG
CCACAAGCGACAAGCGTCCATTGTTTGTTTGGATTGAACTTTGCTGCTTTAGCTTCGACTGTTTG
TGCTCAAAAAGTTCGAGTTCGCCGAGAGAAGCGTGAAAATCCGATATCGAAACTACGTTTTTTTT
TTAGTCATTATACCGATTGGCTATGCAAATTTAATTGCGGATCTCCCAAATCATCGAAAAGCCAA
CAGGTCGCCCCTCAACCAAAATAAACACAACAATCGAGCCGCAAATGAAACGGGCAAAAACAGCA
AAGGCAACTGGCGAACCGCTTAACCGGTTTCGAAATATCCATCGTAGCACAGTTTCCTCGTCCAT
ATAATATTCCGATTGCAGTGGATCAAAATATACACACACACACTCGCATATAAATTCGCAGATAT
ACGTTGTTTGTGTGAGTTTCTGTTTGTGGTTCGCGTGAAAAATAGTTTTGACAAATAAATACAAA
GCCAGACGCCGACATAACTGTGAAAATAAACCATAAGCCAGACAGCAGCCATGGGTTATTCCATT
AAGAACTGCGAAACGGGTGAGTTGGAGTACTTCTACACAGACACCGTCCGCGTTAATAGACCGGC
CTTCGATGAGGAGACCGGTGAACCGATCCACGACCAGGTGACCAAGGTTCACTTCCGCAAACACA
CGAATTTCCATGTACCCAAGCACTATCTCCGCGGAACCATATGCGATGAGGTAGACGACGAGCTG
GCCAATACGGTGAGATATGGGGCAGCCACCGCGATTCCCAACAGGGGAAGACGAGATCGGCACCC
AAAAAGGTCACTCCGGGCTACGAACGCGAGGACTATTGTCAAATGGATGGCGTGAGCAACAACAT
AATCCTGGGCTACAACCGCAACCCCTACTTGCTGTTCCTGGTGCCCACGCTCTTCTGCTACAACT
TCGTCATTGGAGCCACGCTGGCCCTCATCGAGATCGTCCTGCACATGATGTCCCACCACAGGAAC
GGTCTCACCATGCAGAAGAGCCTGTACTTCCGTAGTCCACTCAACGTGCTGTCCTCGCAGTTCTG
CGCCATCTGCCGCACGGAAACCGACAGCAAGTACAACCGCATCTTCGATATCCTTAACAAGCAGA
TGCGCAACGCACATCGCTCCGAGGCGCTGAAGGACATGGCCAAGGCAATTGGATAAGCTGGGAGA
GATTCGATTTGATATGGTCCATATATTTAACACAAATGTTTTTGTCACACGGTCAACAAAAAATA
AATGCACTCGTTTATCACTCAAAAAAAAAAAAAAAAA
MOOSE

$s1 =~ s/\n//g;
$s2 =~ s/\n//g;

$aRef = getMSPs($s1, $s2);
@sortedmsps = sort {$a->getPos2() <=> $b->getPos2()} @{$aRef};

#use Data::Dumper;
#if (defined($aRef)) {
#  print "str1 length: ", length($s1), ", str2 length: " , length($s2), "\n";
#  foreach $msp (@sortedmsps) {
#    print $msp->dump();
#  }
#}

Not() if (scalar(@{$aRef}) != 4); Ok($i++);
Not() if ($sortedmsps[0]->getPos1 != 850); Ok($i++);
Not() if ($sortedmsps[1]->getPos2 != 14); Ok($i++);
Not() if ($sortedmsps[2]->getLen != 172); Ok($i++);
Not() if ($sortedmsps[3]->getLen != 14); Ok($i++);

#
# Let's generate some MSP's with a different acceptance threshold.
#
$GH::MspTools::mspThreshold = 20;
$aRef = getMSPs($s1, $s2);
@sortedmsps = sort {$a->getPos2() <=> $b->getPos2()} @{$aRef};

Not() if (scalar(@{$aRef}) != 1); Ok($i++);
Not() if ($sortedmsps[0]->getPos1 != 876); Ok($i++);
Not() if ($sortedmsps[0]->getPos2 != 28); Ok($i++);
Not() if ($sortedmsps[0]->getLen != 172); Ok($i++);


