#! /usr/bin/perl -w
################################################################################
#
# file.t (Test File PML module)
#
################################################################################
#
# Includes
#
################################################################################
use strict;
use Test;
################################################################################
#
# Setup
#
################################################################################
BEGIN {
	plan test => 5
} use PML;
################################################################################
#
# Start
#
################################################################################
my ($parser, @code, $output);

$parser = new PML;
@code = <DATA>;
$parser->parse(\@code); ok(1);
$output = $parser->execute;

if ($output =~ /0/) {
	ok(0);
} else {
	ok(1);
}
ok($output =~ /This is a test of cat/);
ok($output =~ /1/ and $output =~ /3/);
ok($output =~ /Line cont/);
################################################################################
#                              END-OF-SCRIPT                                   #
################################################################################
__END__
@warning(1)
@need(File)
@file::cat( t/file.cat )
@file::conf( t/file.conf )
${conf.test}
${conf.test2}
${conf.test3}
