// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetAPI5GatewaysParams creates a new GetAPI5GatewaysParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetAPI5GatewaysParams() *GetAPI5GatewaysParams {
	return &GetAPI5GatewaysParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetAPI5GatewaysParamsWithTimeout creates a new GetAPI5GatewaysParams object
// with the ability to set a timeout on a request.
func NewGetAPI5GatewaysParamsWithTimeout(timeout time.Duration) *GetAPI5GatewaysParams {
	return &GetAPI5GatewaysParams{
		timeout: timeout,
	}
}

// NewGetAPI5GatewaysParamsWithContext creates a new GetAPI5GatewaysParams object
// with the ability to set a context for a request.
func NewGetAPI5GatewaysParamsWithContext(ctx context.Context) *GetAPI5GatewaysParams {
	return &GetAPI5GatewaysParams{
		Context: ctx,
	}
}

// NewGetAPI5GatewaysParamsWithHTTPClient creates a new GetAPI5GatewaysParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetAPI5GatewaysParamsWithHTTPClient(client *http.Client) *GetAPI5GatewaysParams {
	return &GetAPI5GatewaysParams{
		HTTPClient: client,
	}
}

/*
GetAPI5GatewaysParams contains all the parameters to send to the API endpoint

	for the get API 5 gateways operation.

	Typically these are written to a http.Request.
*/
type GetAPI5GatewaysParams struct {

	/* Byload.

	   Sort by load (experimental)
	*/
	Byload *bool

	/* Cc.

	   base country code (ISO-2)
	*/
	Cc *string

	/* Loc.

	   location override
	*/
	Loc *string

	/* Port.

	   port
	*/
	Port *string

	/* Tr.

	   transport (tcp|udp)
	*/
	Tr *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get API 5 gateways params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAPI5GatewaysParams) WithDefaults() *GetAPI5GatewaysParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get API 5 gateways params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAPI5GatewaysParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get API 5 gateways params
func (o *GetAPI5GatewaysParams) WithTimeout(timeout time.Duration) *GetAPI5GatewaysParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get API 5 gateways params
func (o *GetAPI5GatewaysParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get API 5 gateways params
func (o *GetAPI5GatewaysParams) WithContext(ctx context.Context) *GetAPI5GatewaysParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get API 5 gateways params
func (o *GetAPI5GatewaysParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get API 5 gateways params
func (o *GetAPI5GatewaysParams) WithHTTPClient(client *http.Client) *GetAPI5GatewaysParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get API 5 gateways params
func (o *GetAPI5GatewaysParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithByload adds the byload to the get API 5 gateways params
func (o *GetAPI5GatewaysParams) WithByload(byload *bool) *GetAPI5GatewaysParams {
	o.SetByload(byload)
	return o
}

// SetByload adds the byload to the get API 5 gateways params
func (o *GetAPI5GatewaysParams) SetByload(byload *bool) {
	o.Byload = byload
}

// WithCc adds the cc to the get API 5 gateways params
func (o *GetAPI5GatewaysParams) WithCc(cc *string) *GetAPI5GatewaysParams {
	o.SetCc(cc)
	return o
}

// SetCc adds the cc to the get API 5 gateways params
func (o *GetAPI5GatewaysParams) SetCc(cc *string) {
	o.Cc = cc
}

// WithLoc adds the loc to the get API 5 gateways params
func (o *GetAPI5GatewaysParams) WithLoc(loc *string) *GetAPI5GatewaysParams {
	o.SetLoc(loc)
	return o
}

// SetLoc adds the loc to the get API 5 gateways params
func (o *GetAPI5GatewaysParams) SetLoc(loc *string) {
	o.Loc = loc
}

// WithPort adds the port to the get API 5 gateways params
func (o *GetAPI5GatewaysParams) WithPort(port *string) *GetAPI5GatewaysParams {
	o.SetPort(port)
	return o
}

// SetPort adds the port to the get API 5 gateways params
func (o *GetAPI5GatewaysParams) SetPort(port *string) {
	o.Port = port
}

// WithTr adds the tr to the get API 5 gateways params
func (o *GetAPI5GatewaysParams) WithTr(tr *string) *GetAPI5GatewaysParams {
	o.SetTr(tr)
	return o
}

// SetTr adds the tr to the get API 5 gateways params
func (o *GetAPI5GatewaysParams) SetTr(tr *string) {
	o.Tr = tr
}

// WriteToRequest writes these params to a swagger request
func (o *GetAPI5GatewaysParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Byload != nil {

		// query param byload
		var qrByload bool

		if o.Byload != nil {
			qrByload = *o.Byload
		}
		qByload := swag.FormatBool(qrByload)
		if qByload != "" {

			if err := r.SetQueryParam("byload", qByload); err != nil {
				return err
			}
		}
	}

	if o.Cc != nil {

		// query param cc
		var qrCc string

		if o.Cc != nil {
			qrCc = *o.Cc
		}
		qCc := qrCc
		if qCc != "" {

			if err := r.SetQueryParam("cc", qCc); err != nil {
				return err
			}
		}
	}

	if o.Loc != nil {

		// query param loc
		var qrLoc string

		if o.Loc != nil {
			qrLoc = *o.Loc
		}
		qLoc := qrLoc
		if qLoc != "" {

			if err := r.SetQueryParam("loc", qLoc); err != nil {
				return err
			}
		}
	}

	if o.Port != nil {

		// query param port
		var qrPort string

		if o.Port != nil {
			qrPort = *o.Port
		}
		qPort := qrPort
		if qPort != "" {

			if err := r.SetQueryParam("port", qPort); err != nil {
				return err
			}
		}
	}

	if o.Tr != nil {

		// query param tr
		var qrTr string

		if o.Tr != nil {
			qrTr = *o.Tr
		}
		qTr := qrTr
		if qTr != "" {

			if err := r.SetQueryParam("tr", qTr); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
