# Generated by Django 4.2.14 on 2024-08-03 13:06

from django.db import migrations

# Previously, a hardcoded default was used in case the fields were left blank.
# We now need to fill in these hardcoded defaults.
SBUILD_CONFIG_BLOCKS_DEFAULT = "set-default-path ccache"
SBUILD_SETUP_BLOCKS_DEFAULT = "apt-setup apt-update ccache eatmydata"


def migrate_sbuild_blocks(apps, _schema_editor):
    Distribution = apps.get_model("mini_buildd", "Distribution")
    for d in Distribution.objects.all():
        if not d.sbuild_config_blocks:
            d.sbuild_config_blocks = SBUILD_CONFIG_BLOCKS_DEFAULT
        if not d.sbuild_setup_blocks:
            d.sbuild_setup_blocks = SBUILD_SETUP_BLOCKS_DEFAULT
        d.save()


class Migration(migrations.Migration):

    dependencies = [
        ('mini_buildd', '0035_alter_distribution_sbuild_config_blocks_and_more'),
    ]

    operations = [
        migrations.RunPython(migrate_sbuild_blocks),
    ]
