# Generated by Django 4.2.9 on 2024-01-07 17:02

from django.db import migrations

from . import mbd_get_extra_option


def copy_extra_options(apps, _schema_editor):
    Chroot = apps.get_model("mini_buildd", "Chroot")
    for chroot in Chroot.objects.all():
        debootstrap_command = mbd_get_extra_option(chroot, "Debootstrap-Command")
        if debootstrap_command is not None:
            chroot.debootstrap_command = debootstrap_command
        chroot.debootstrap_extra_options = mbd_get_extra_option(chroot, "Debootstrap-Extra-Options", "")
        chroot.save()


class Migration(migrations.Migration):

    dependencies = [
        ('mini_buildd', '0018_add_chroot_extra_options'),
    ]

    operations = [
        migrations.RunPython(copy_extra_options),
    ]
