// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::LeafletTransitionType;
use crate::NavigationDirection;
use crate::Swipeable;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "HdyLeaflet")]
    pub struct Leaflet(Object<ffi::HdyLeaflet, ffi::HdyLeafletClass>) @extends gtk::Container, gtk::Widget, @implements gtk::Buildable, gtk::Orientable, Swipeable;

    match fn {
        type_ => || ffi::hdy_leaflet_get_type(),
    }
}

impl Leaflet {
    #[doc(alias = "hdy_leaflet_new")]
    pub fn new() -> Leaflet {
        assert_initialized_main_thread!();
        unsafe { gtk::Widget::from_glib_none(ffi::hdy_leaflet_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Leaflet`] objects.
    ///
    /// This method returns an instance of [`LeafletBuilder`] which can be used to create [`Leaflet`] objects.
    pub fn builder() -> LeafletBuilder {
        LeafletBuilder::default()
    }
}

impl Default for Leaflet {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Leaflet`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
pub struct LeafletBuilder {
    can_swipe_back: Option<bool>,
    can_swipe_forward: Option<bool>,
    child_transition_duration: Option<u32>,
    hhomogeneous_folded: Option<bool>,
    hhomogeneous_unfolded: Option<bool>,
    interpolate_size: Option<bool>,
    mode_transition_duration: Option<u32>,
    transition_type: Option<LeafletTransitionType>,
    vhomogeneous_folded: Option<bool>,
    vhomogeneous_unfolded: Option<bool>,
    visible_child: Option<gtk::Widget>,
    visible_child_name: Option<String>,
    border_width: Option<u32>,
    child: Option<gtk::Widget>,
    resize_mode: Option<gtk::ResizeMode>,
    app_paintable: Option<bool>,
    can_default: Option<bool>,
    can_focus: Option<bool>,
    double_buffered: Option<bool>,
    events: Option<gdk::EventMask>,
    expand: Option<bool>,
    focus_on_click: Option<bool>,
    halign: Option<gtk::Align>,
    has_default: Option<bool>,
    has_focus: Option<bool>,
    has_tooltip: Option<bool>,
    height_request: Option<i32>,
    hexpand: Option<bool>,
    hexpand_set: Option<bool>,
    is_focus: Option<bool>,
    margin: Option<i32>,
    margin_bottom: Option<i32>,
    margin_end: Option<i32>,
    margin_left: Option<i32>,
    margin_right: Option<i32>,
    margin_start: Option<i32>,
    margin_top: Option<i32>,
    name: Option<String>,
    no_show_all: Option<bool>,
    opacity: Option<f64>,
    parent: Option<gtk::Container>,
    receives_default: Option<bool>,
    sensitive: Option<bool>,
    //style: /*Unknown type*/,
    tooltip_markup: Option<String>,
    tooltip_text: Option<String>,
    valign: Option<gtk::Align>,
    vexpand: Option<bool>,
    vexpand_set: Option<bool>,
    visible: Option<bool>,
    width_request: Option<i32>,
    orientation: Option<gtk::Orientation>,
}

impl LeafletBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`LeafletBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Leaflet`].
    pub fn build(self) -> Leaflet {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref can_swipe_back) = self.can_swipe_back {
            properties.push(("can-swipe-back", can_swipe_back));
        }
        if let Some(ref can_swipe_forward) = self.can_swipe_forward {
            properties.push(("can-swipe-forward", can_swipe_forward));
        }
        if let Some(ref child_transition_duration) = self.child_transition_duration {
            properties.push(("child-transition-duration", child_transition_duration));
        }
        if let Some(ref hhomogeneous_folded) = self.hhomogeneous_folded {
            properties.push(("hhomogeneous-folded", hhomogeneous_folded));
        }
        if let Some(ref hhomogeneous_unfolded) = self.hhomogeneous_unfolded {
            properties.push(("hhomogeneous-unfolded", hhomogeneous_unfolded));
        }
        if let Some(ref interpolate_size) = self.interpolate_size {
            properties.push(("interpolate-size", interpolate_size));
        }
        if let Some(ref mode_transition_duration) = self.mode_transition_duration {
            properties.push(("mode-transition-duration", mode_transition_duration));
        }
        if let Some(ref transition_type) = self.transition_type {
            properties.push(("transition-type", transition_type));
        }
        if let Some(ref vhomogeneous_folded) = self.vhomogeneous_folded {
            properties.push(("vhomogeneous-folded", vhomogeneous_folded));
        }
        if let Some(ref vhomogeneous_unfolded) = self.vhomogeneous_unfolded {
            properties.push(("vhomogeneous-unfolded", vhomogeneous_unfolded));
        }
        if let Some(ref visible_child) = self.visible_child {
            properties.push(("visible-child", visible_child));
        }
        if let Some(ref visible_child_name) = self.visible_child_name {
            properties.push(("visible-child-name", visible_child_name));
        }
        if let Some(ref border_width) = self.border_width {
            properties.push(("border-width", border_width));
        }
        if let Some(ref child) = self.child {
            properties.push(("child", child));
        }
        if let Some(ref resize_mode) = self.resize_mode {
            properties.push(("resize-mode", resize_mode));
        }
        if let Some(ref app_paintable) = self.app_paintable {
            properties.push(("app-paintable", app_paintable));
        }
        if let Some(ref can_default) = self.can_default {
            properties.push(("can-default", can_default));
        }
        if let Some(ref can_focus) = self.can_focus {
            properties.push(("can-focus", can_focus));
        }
        if let Some(ref double_buffered) = self.double_buffered {
            properties.push(("double-buffered", double_buffered));
        }
        if let Some(ref events) = self.events {
            properties.push(("events", events));
        }
        if let Some(ref expand) = self.expand {
            properties.push(("expand", expand));
        }
        if let Some(ref focus_on_click) = self.focus_on_click {
            properties.push(("focus-on-click", focus_on_click));
        }
        if let Some(ref halign) = self.halign {
            properties.push(("halign", halign));
        }
        if let Some(ref has_default) = self.has_default {
            properties.push(("has-default", has_default));
        }
        if let Some(ref has_focus) = self.has_focus {
            properties.push(("has-focus", has_focus));
        }
        if let Some(ref has_tooltip) = self.has_tooltip {
            properties.push(("has-tooltip", has_tooltip));
        }
        if let Some(ref height_request) = self.height_request {
            properties.push(("height-request", height_request));
        }
        if let Some(ref hexpand) = self.hexpand {
            properties.push(("hexpand", hexpand));
        }
        if let Some(ref hexpand_set) = self.hexpand_set {
            properties.push(("hexpand-set", hexpand_set));
        }
        if let Some(ref is_focus) = self.is_focus {
            properties.push(("is-focus", is_focus));
        }
        if let Some(ref margin) = self.margin {
            properties.push(("margin", margin));
        }
        if let Some(ref margin_bottom) = self.margin_bottom {
            properties.push(("margin-bottom", margin_bottom));
        }
        if let Some(ref margin_end) = self.margin_end {
            properties.push(("margin-end", margin_end));
        }
        if let Some(ref margin_left) = self.margin_left {
            properties.push(("margin-left", margin_left));
        }
        if let Some(ref margin_right) = self.margin_right {
            properties.push(("margin-right", margin_right));
        }
        if let Some(ref margin_start) = self.margin_start {
            properties.push(("margin-start", margin_start));
        }
        if let Some(ref margin_top) = self.margin_top {
            properties.push(("margin-top", margin_top));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        if let Some(ref no_show_all) = self.no_show_all {
            properties.push(("no-show-all", no_show_all));
        }
        if let Some(ref opacity) = self.opacity {
            properties.push(("opacity", opacity));
        }
        if let Some(ref parent) = self.parent {
            properties.push(("parent", parent));
        }
        if let Some(ref receives_default) = self.receives_default {
            properties.push(("receives-default", receives_default));
        }
        if let Some(ref sensitive) = self.sensitive {
            properties.push(("sensitive", sensitive));
        }
        if let Some(ref tooltip_markup) = self.tooltip_markup {
            properties.push(("tooltip-markup", tooltip_markup));
        }
        if let Some(ref tooltip_text) = self.tooltip_text {
            properties.push(("tooltip-text", tooltip_text));
        }
        if let Some(ref valign) = self.valign {
            properties.push(("valign", valign));
        }
        if let Some(ref vexpand) = self.vexpand {
            properties.push(("vexpand", vexpand));
        }
        if let Some(ref vexpand_set) = self.vexpand_set {
            properties.push(("vexpand-set", vexpand_set));
        }
        if let Some(ref visible) = self.visible {
            properties.push(("visible", visible));
        }
        if let Some(ref width_request) = self.width_request {
            properties.push(("width-request", width_request));
        }
        if let Some(ref orientation) = self.orientation {
            properties.push(("orientation", orientation));
        }
        glib::Object::new::<Leaflet>(&properties).expect("Failed to create an instance of Leaflet")
    }

    pub fn can_swipe_back(mut self, can_swipe_back: bool) -> Self {
        self.can_swipe_back = Some(can_swipe_back);
        self
    }

    pub fn can_swipe_forward(mut self, can_swipe_forward: bool) -> Self {
        self.can_swipe_forward = Some(can_swipe_forward);
        self
    }

    pub fn child_transition_duration(mut self, child_transition_duration: u32) -> Self {
        self.child_transition_duration = Some(child_transition_duration);
        self
    }

    pub fn hhomogeneous_folded(mut self, hhomogeneous_folded: bool) -> Self {
        self.hhomogeneous_folded = Some(hhomogeneous_folded);
        self
    }

    pub fn hhomogeneous_unfolded(mut self, hhomogeneous_unfolded: bool) -> Self {
        self.hhomogeneous_unfolded = Some(hhomogeneous_unfolded);
        self
    }

    pub fn interpolate_size(mut self, interpolate_size: bool) -> Self {
        self.interpolate_size = Some(interpolate_size);
        self
    }

    pub fn mode_transition_duration(mut self, mode_transition_duration: u32) -> Self {
        self.mode_transition_duration = Some(mode_transition_duration);
        self
    }

    pub fn transition_type(mut self, transition_type: LeafletTransitionType) -> Self {
        self.transition_type = Some(transition_type);
        self
    }

    pub fn vhomogeneous_folded(mut self, vhomogeneous_folded: bool) -> Self {
        self.vhomogeneous_folded = Some(vhomogeneous_folded);
        self
    }

    pub fn vhomogeneous_unfolded(mut self, vhomogeneous_unfolded: bool) -> Self {
        self.vhomogeneous_unfolded = Some(vhomogeneous_unfolded);
        self
    }

    pub fn visible_child<P: IsA<gtk::Widget>>(mut self, visible_child: &P) -> Self {
        self.visible_child = Some(visible_child.clone().upcast());
        self
    }

    pub fn visible_child_name(mut self, visible_child_name: &str) -> Self {
        self.visible_child_name = Some(visible_child_name.to_string());
        self
    }

    pub fn border_width(mut self, border_width: u32) -> Self {
        self.border_width = Some(border_width);
        self
    }

    pub fn child<P: IsA<gtk::Widget>>(mut self, child: &P) -> Self {
        self.child = Some(child.clone().upcast());
        self
    }

    pub fn resize_mode(mut self, resize_mode: gtk::ResizeMode) -> Self {
        self.resize_mode = Some(resize_mode);
        self
    }

    pub fn app_paintable(mut self, app_paintable: bool) -> Self {
        self.app_paintable = Some(app_paintable);
        self
    }

    pub fn can_default(mut self, can_default: bool) -> Self {
        self.can_default = Some(can_default);
        self
    }

    pub fn can_focus(mut self, can_focus: bool) -> Self {
        self.can_focus = Some(can_focus);
        self
    }

    pub fn double_buffered(mut self, double_buffered: bool) -> Self {
        self.double_buffered = Some(double_buffered);
        self
    }

    pub fn events(mut self, events: gdk::EventMask) -> Self {
        self.events = Some(events);
        self
    }

    pub fn expand(mut self, expand: bool) -> Self {
        self.expand = Some(expand);
        self
    }

    pub fn focus_on_click(mut self, focus_on_click: bool) -> Self {
        self.focus_on_click = Some(focus_on_click);
        self
    }

    pub fn halign(mut self, halign: gtk::Align) -> Self {
        self.halign = Some(halign);
        self
    }

    pub fn has_default(mut self, has_default: bool) -> Self {
        self.has_default = Some(has_default);
        self
    }

    pub fn has_focus(mut self, has_focus: bool) -> Self {
        self.has_focus = Some(has_focus);
        self
    }

    pub fn has_tooltip(mut self, has_tooltip: bool) -> Self {
        self.has_tooltip = Some(has_tooltip);
        self
    }

    pub fn height_request(mut self, height_request: i32) -> Self {
        self.height_request = Some(height_request);
        self
    }

    pub fn hexpand(mut self, hexpand: bool) -> Self {
        self.hexpand = Some(hexpand);
        self
    }

    pub fn hexpand_set(mut self, hexpand_set: bool) -> Self {
        self.hexpand_set = Some(hexpand_set);
        self
    }

    pub fn is_focus(mut self, is_focus: bool) -> Self {
        self.is_focus = Some(is_focus);
        self
    }

    pub fn margin(mut self, margin: i32) -> Self {
        self.margin = Some(margin);
        self
    }

    pub fn margin_bottom(mut self, margin_bottom: i32) -> Self {
        self.margin_bottom = Some(margin_bottom);
        self
    }

    pub fn margin_end(mut self, margin_end: i32) -> Self {
        self.margin_end = Some(margin_end);
        self
    }

    pub fn margin_left(mut self, margin_left: i32) -> Self {
        self.margin_left = Some(margin_left);
        self
    }

    pub fn margin_right(mut self, margin_right: i32) -> Self {
        self.margin_right = Some(margin_right);
        self
    }

    pub fn margin_start(mut self, margin_start: i32) -> Self {
        self.margin_start = Some(margin_start);
        self
    }

    pub fn margin_top(mut self, margin_top: i32) -> Self {
        self.margin_top = Some(margin_top);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }

    pub fn no_show_all(mut self, no_show_all: bool) -> Self {
        self.no_show_all = Some(no_show_all);
        self
    }

    pub fn opacity(mut self, opacity: f64) -> Self {
        self.opacity = Some(opacity);
        self
    }

    pub fn parent<P: IsA<gtk::Container>>(mut self, parent: &P) -> Self {
        self.parent = Some(parent.clone().upcast());
        self
    }

    pub fn receives_default(mut self, receives_default: bool) -> Self {
        self.receives_default = Some(receives_default);
        self
    }

    pub fn sensitive(mut self, sensitive: bool) -> Self {
        self.sensitive = Some(sensitive);
        self
    }

    pub fn tooltip_markup(mut self, tooltip_markup: &str) -> Self {
        self.tooltip_markup = Some(tooltip_markup.to_string());
        self
    }

    pub fn tooltip_text(mut self, tooltip_text: &str) -> Self {
        self.tooltip_text = Some(tooltip_text.to_string());
        self
    }

    pub fn valign(mut self, valign: gtk::Align) -> Self {
        self.valign = Some(valign);
        self
    }

    pub fn vexpand(mut self, vexpand: bool) -> Self {
        self.vexpand = Some(vexpand);
        self
    }

    pub fn vexpand_set(mut self, vexpand_set: bool) -> Self {
        self.vexpand_set = Some(vexpand_set);
        self
    }

    pub fn visible(mut self, visible: bool) -> Self {
        self.visible = Some(visible);
        self
    }

    pub fn width_request(mut self, width_request: i32) -> Self {
        self.width_request = Some(width_request);
        self
    }

    pub fn orientation(mut self, orientation: gtk::Orientation) -> Self {
        self.orientation = Some(orientation);
        self
    }
}

pub const NONE_LEAFLET: Option<&Leaflet> = None;

pub trait LeafletExt: 'static {
    #[doc(alias = "hdy_leaflet_get_adjacent_child")]
    #[doc(alias = "get_adjacent_child")]
    fn adjacent_child(&self, direction: NavigationDirection) -> Option<gtk::Widget>;

    #[doc(alias = "hdy_leaflet_get_can_swipe_back")]
    #[doc(alias = "get_can_swipe_back")]
    fn can_swipe_back(&self) -> bool;

    #[doc(alias = "hdy_leaflet_get_can_swipe_forward")]
    #[doc(alias = "get_can_swipe_forward")]
    fn can_swipe_forward(&self) -> bool;

    #[doc(alias = "hdy_leaflet_get_child_by_name")]
    #[doc(alias = "get_child_by_name")]
    fn child_by_name(&self, name: &str) -> Option<gtk::Widget>;

    #[doc(alias = "hdy_leaflet_get_child_transition_duration")]
    #[doc(alias = "get_child_transition_duration")]
    fn child_transition_duration(&self) -> u32;

    #[doc(alias = "hdy_leaflet_get_child_transition_running")]
    #[doc(alias = "get_child_transition_running")]
    fn is_child_transition_running(&self) -> bool;

    #[doc(alias = "hdy_leaflet_get_folded")]
    #[doc(alias = "get_folded")]
    fn is_folded(&self) -> bool;

    #[doc(alias = "hdy_leaflet_get_homogeneous")]
    #[doc(alias = "get_homogeneous")]
    fn is_homogeneous(&self, folded: bool, orientation: gtk::Orientation) -> bool;

    #[doc(alias = "hdy_leaflet_get_interpolate_size")]
    #[doc(alias = "get_interpolate_size")]
    fn is_interpolate_size(&self) -> bool;

    #[doc(alias = "hdy_leaflet_get_mode_transition_duration")]
    #[doc(alias = "get_mode_transition_duration")]
    fn mode_transition_duration(&self) -> u32;

    #[doc(alias = "hdy_leaflet_get_transition_type")]
    #[doc(alias = "get_transition_type")]
    fn transition_type(&self) -> LeafletTransitionType;

    #[doc(alias = "hdy_leaflet_get_visible_child")]
    #[doc(alias = "get_visible_child")]
    fn visible_child(&self) -> Option<gtk::Widget>;

    #[doc(alias = "hdy_leaflet_get_visible_child_name")]
    #[doc(alias = "get_visible_child_name")]
    fn visible_child_name(&self) -> Option<glib::GString>;

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    #[doc(alias = "hdy_leaflet_insert_child_after")]
    fn insert_child_after<P: IsA<gtk::Widget>, Q: IsA<gtk::Widget>>(
        &self,
        child: &P,
        sibling: Option<&Q>,
    );

    #[doc(alias = "hdy_leaflet_navigate")]
    fn navigate(&self, direction: NavigationDirection) -> bool;

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    #[doc(alias = "hdy_leaflet_prepend")]
    fn prepend<P: IsA<gtk::Widget>>(&self, child: &P);

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    #[doc(alias = "hdy_leaflet_reorder_child_after")]
    fn reorder_child_after<P: IsA<gtk::Widget>, Q: IsA<gtk::Widget>>(
        &self,
        child: &P,
        sibling: Option<&Q>,
    );

    #[doc(alias = "hdy_leaflet_set_can_swipe_back")]
    fn set_can_swipe_back(&self, can_swipe_back: bool);

    #[doc(alias = "hdy_leaflet_set_can_swipe_forward")]
    fn set_can_swipe_forward(&self, can_swipe_forward: bool);

    #[doc(alias = "hdy_leaflet_set_child_transition_duration")]
    fn set_child_transition_duration(&self, duration: u32);

    #[doc(alias = "hdy_leaflet_set_homogeneous")]
    fn set_homogeneous(&self, folded: bool, orientation: gtk::Orientation, homogeneous: bool);

    #[doc(alias = "hdy_leaflet_set_interpolate_size")]
    fn set_interpolate_size(&self, interpolate_size: bool);

    #[doc(alias = "hdy_leaflet_set_mode_transition_duration")]
    fn set_mode_transition_duration(&self, duration: u32);

    #[doc(alias = "hdy_leaflet_set_transition_type")]
    fn set_transition_type(&self, transition: LeafletTransitionType);

    #[doc(alias = "hdy_leaflet_set_visible_child")]
    fn set_visible_child<P: IsA<gtk::Widget>>(&self, visible_child: &P);

    #[doc(alias = "hdy_leaflet_set_visible_child_name")]
    fn set_visible_child_name(&self, name: &str);

    #[doc(alias = "hhomogeneous-folded")]
    fn is_hhomogeneous_folded(&self) -> bool;

    #[doc(alias = "hhomogeneous-folded")]
    fn set_hhomogeneous_folded(&self, hhomogeneous_folded: bool);

    #[doc(alias = "hhomogeneous-unfolded")]
    fn is_hhomogeneous_unfolded(&self) -> bool;

    #[doc(alias = "hhomogeneous-unfolded")]
    fn set_hhomogeneous_unfolded(&self, hhomogeneous_unfolded: bool);

    #[doc(alias = "vhomogeneous-folded")]
    fn is_vhomogeneous_folded(&self) -> bool;

    #[doc(alias = "vhomogeneous-folded")]
    fn set_vhomogeneous_folded(&self, vhomogeneous_folded: bool);

    #[doc(alias = "vhomogeneous-unfolded")]
    fn is_vhomogeneous_unfolded(&self) -> bool;

    #[doc(alias = "vhomogeneous-unfolded")]
    fn set_vhomogeneous_unfolded(&self, vhomogeneous_unfolded: bool);

    #[doc(alias = "child.icon-name")]
    fn child_icon_name<T: IsA<gtk::Widget>>(&self, item: &T) -> Option<glib::GString>;

    #[doc(alias = "child.icon-name")]
    fn set_child_icon_name<T: IsA<gtk::Widget>>(&self, item: &T, icon_name: Option<&str>);

    fn child_name<T: IsA<gtk::Widget>>(&self, item: &T) -> Option<glib::GString>;

    fn set_child_name<T: IsA<gtk::Widget>>(&self, item: &T, name: Option<&str>);

    #[doc(alias = "child.needs-attention")]
    fn child_needs_attention<T: IsA<gtk::Widget>>(&self, item: &T) -> bool;

    #[doc(alias = "child.needs-attention")]
    fn set_child_needs_attention<T: IsA<gtk::Widget>>(&self, item: &T, needs_attention: bool);

    fn child_position<T: IsA<gtk::Widget>>(&self, item: &T) -> i32;

    fn set_child_position<T: IsA<gtk::Widget>>(&self, item: &T, position: i32);

    fn child_title<T: IsA<gtk::Widget>>(&self, item: &T) -> Option<glib::GString>;

    fn set_child_title<T: IsA<gtk::Widget>>(&self, item: &T, title: Option<&str>);

    #[doc(alias = "can-swipe-back")]
    fn connect_can_swipe_back_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "can-swipe-forward")]
    fn connect_can_swipe_forward_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "child-transition-duration")]
    fn connect_child_transition_duration_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "child-transition-running")]
    fn connect_child_transition_running_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "folded")]
    fn connect_folded_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "hhomogeneous-folded")]
    fn connect_hhomogeneous_folded_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "hhomogeneous-unfolded")]
    fn connect_hhomogeneous_unfolded_notify<F: Fn(&Self) + 'static>(&self, f: F)
        -> SignalHandlerId;

    #[doc(alias = "interpolate-size")]
    fn connect_interpolate_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "mode-transition-duration")]
    fn connect_mode_transition_duration_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "transition-type")]
    fn connect_transition_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "vhomogeneous-folded")]
    fn connect_vhomogeneous_folded_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "vhomogeneous-unfolded")]
    fn connect_vhomogeneous_unfolded_notify<F: Fn(&Self) + 'static>(&self, f: F)
        -> SignalHandlerId;

    #[doc(alias = "visible-child")]
    fn connect_visible_child_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "visible-child-name")]
    fn connect_visible_child_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Leaflet>> LeafletExt for O {
    fn adjacent_child(&self, direction: NavigationDirection) -> Option<gtk::Widget> {
        unsafe {
            from_glib_none(ffi::hdy_leaflet_get_adjacent_child(
                self.as_ref().to_glib_none().0,
                direction.into_glib(),
            ))
        }
    }

    fn can_swipe_back(&self) -> bool {
        unsafe {
            from_glib(ffi::hdy_leaflet_get_can_swipe_back(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn can_swipe_forward(&self) -> bool {
        unsafe {
            from_glib(ffi::hdy_leaflet_get_can_swipe_forward(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn child_by_name(&self, name: &str) -> Option<gtk::Widget> {
        unsafe {
            from_glib_none(ffi::hdy_leaflet_get_child_by_name(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
            ))
        }
    }

    fn child_transition_duration(&self) -> u32 {
        unsafe { ffi::hdy_leaflet_get_child_transition_duration(self.as_ref().to_glib_none().0) }
    }

    fn is_child_transition_running(&self) -> bool {
        unsafe {
            from_glib(ffi::hdy_leaflet_get_child_transition_running(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_folded(&self) -> bool {
        unsafe { from_glib(ffi::hdy_leaflet_get_folded(self.as_ref().to_glib_none().0)) }
    }

    fn is_homogeneous(&self, folded: bool, orientation: gtk::Orientation) -> bool {
        unsafe {
            from_glib(ffi::hdy_leaflet_get_homogeneous(
                self.as_ref().to_glib_none().0,
                folded.into_glib(),
                orientation.into_glib(),
            ))
        }
    }

    fn is_interpolate_size(&self) -> bool {
        unsafe {
            from_glib(ffi::hdy_leaflet_get_interpolate_size(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn mode_transition_duration(&self) -> u32 {
        unsafe { ffi::hdy_leaflet_get_mode_transition_duration(self.as_ref().to_glib_none().0) }
    }

    fn transition_type(&self) -> LeafletTransitionType {
        unsafe {
            from_glib(ffi::hdy_leaflet_get_transition_type(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn visible_child(&self) -> Option<gtk::Widget> {
        unsafe {
            from_glib_none(ffi::hdy_leaflet_get_visible_child(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn visible_child_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::hdy_leaflet_get_visible_child_name(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    fn insert_child_after<P: IsA<gtk::Widget>, Q: IsA<gtk::Widget>>(
        &self,
        child: &P,
        sibling: Option<&Q>,
    ) {
        unsafe {
            ffi::hdy_leaflet_insert_child_after(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                sibling.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn navigate(&self, direction: NavigationDirection) -> bool {
        unsafe {
            from_glib(ffi::hdy_leaflet_navigate(
                self.as_ref().to_glib_none().0,
                direction.into_glib(),
            ))
        }
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    fn prepend<P: IsA<gtk::Widget>>(&self, child: &P) {
        unsafe {
            ffi::hdy_leaflet_prepend(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
            );
        }
    }

    #[cfg(any(feature = "v1_2", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v1_2")))]
    fn reorder_child_after<P: IsA<gtk::Widget>, Q: IsA<gtk::Widget>>(
        &self,
        child: &P,
        sibling: Option<&Q>,
    ) {
        unsafe {
            ffi::hdy_leaflet_reorder_child_after(
                self.as_ref().to_glib_none().0,
                child.as_ref().to_glib_none().0,
                sibling.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_can_swipe_back(&self, can_swipe_back: bool) {
        unsafe {
            ffi::hdy_leaflet_set_can_swipe_back(
                self.as_ref().to_glib_none().0,
                can_swipe_back.into_glib(),
            );
        }
    }

    fn set_can_swipe_forward(&self, can_swipe_forward: bool) {
        unsafe {
            ffi::hdy_leaflet_set_can_swipe_forward(
                self.as_ref().to_glib_none().0,
                can_swipe_forward.into_glib(),
            );
        }
    }

    fn set_child_transition_duration(&self, duration: u32) {
        unsafe {
            ffi::hdy_leaflet_set_child_transition_duration(
                self.as_ref().to_glib_none().0,
                duration,
            );
        }
    }

    fn set_homogeneous(&self, folded: bool, orientation: gtk::Orientation, homogeneous: bool) {
        unsafe {
            ffi::hdy_leaflet_set_homogeneous(
                self.as_ref().to_glib_none().0,
                folded.into_glib(),
                orientation.into_glib(),
                homogeneous.into_glib(),
            );
        }
    }

    fn set_interpolate_size(&self, interpolate_size: bool) {
        unsafe {
            ffi::hdy_leaflet_set_interpolate_size(
                self.as_ref().to_glib_none().0,
                interpolate_size.into_glib(),
            );
        }
    }

    fn set_mode_transition_duration(&self, duration: u32) {
        unsafe {
            ffi::hdy_leaflet_set_mode_transition_duration(self.as_ref().to_glib_none().0, duration);
        }
    }

    fn set_transition_type(&self, transition: LeafletTransitionType) {
        unsafe {
            ffi::hdy_leaflet_set_transition_type(
                self.as_ref().to_glib_none().0,
                transition.into_glib(),
            );
        }
    }

    fn set_visible_child<P: IsA<gtk::Widget>>(&self, visible_child: &P) {
        unsafe {
            ffi::hdy_leaflet_set_visible_child(
                self.as_ref().to_glib_none().0,
                visible_child.as_ref().to_glib_none().0,
            );
        }
    }

    fn set_visible_child_name(&self, name: &str) {
        unsafe {
            ffi::hdy_leaflet_set_visible_child_name(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
            );
        }
    }

    fn is_hhomogeneous_folded(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"hhomogeneous-folded\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `hhomogeneous-folded` getter")
        }
    }

    fn set_hhomogeneous_folded(&self, hhomogeneous_folded: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"hhomogeneous-folded\0".as_ptr() as *const _,
                hhomogeneous_folded.to_value().to_glib_none().0,
            );
        }
    }

    fn is_hhomogeneous_unfolded(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"hhomogeneous-unfolded\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `hhomogeneous-unfolded` getter")
        }
    }

    fn set_hhomogeneous_unfolded(&self, hhomogeneous_unfolded: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"hhomogeneous-unfolded\0".as_ptr() as *const _,
                hhomogeneous_unfolded.to_value().to_glib_none().0,
            );
        }
    }

    fn is_vhomogeneous_folded(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"vhomogeneous-folded\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `vhomogeneous-folded` getter")
        }
    }

    fn set_vhomogeneous_folded(&self, vhomogeneous_folded: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"vhomogeneous-folded\0".as_ptr() as *const _,
                vhomogeneous_folded.to_value().to_glib_none().0,
            );
        }
    }

    fn is_vhomogeneous_unfolded(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"vhomogeneous-unfolded\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `vhomogeneous-unfolded` getter")
        }
    }

    fn set_vhomogeneous_unfolded(&self, vhomogeneous_unfolded: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(
                self.to_glib_none().0 as *mut glib::gobject_ffi::GObject,
                b"vhomogeneous-unfolded\0".as_ptr() as *const _,
                vhomogeneous_unfolded.to_value().to_glib_none().0,
            );
        }
    }

    fn child_icon_name<T: IsA<gtk::Widget>>(&self, item: &T) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            gtk::ffi::gtk_container_child_get_property(
                self.to_glib_none().0 as *mut gtk::ffi::GtkContainer,
                item.to_glib_none().0 as *mut _,
                b"icon-name\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `icon-name` getter")
        }
    }

    fn set_child_icon_name<T: IsA<gtk::Widget>>(&self, item: &T, icon_name: Option<&str>) {
        unsafe {
            gtk::ffi::gtk_container_child_set_property(
                self.to_glib_none().0 as *mut gtk::ffi::GtkContainer,
                item.to_glib_none().0 as *mut _,
                b"icon-name\0".as_ptr() as *const _,
                icon_name.to_value().to_glib_none().0,
            );
        }
    }

    fn child_name<T: IsA<gtk::Widget>>(&self, item: &T) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            gtk::ffi::gtk_container_child_get_property(
                self.to_glib_none().0 as *mut gtk::ffi::GtkContainer,
                item.to_glib_none().0 as *mut _,
                b"name\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `name` getter")
        }
    }

    fn set_child_name<T: IsA<gtk::Widget>>(&self, item: &T, name: Option<&str>) {
        unsafe {
            gtk::ffi::gtk_container_child_set_property(
                self.to_glib_none().0 as *mut gtk::ffi::GtkContainer,
                item.to_glib_none().0 as *mut _,
                b"name\0".as_ptr() as *const _,
                name.to_value().to_glib_none().0,
            );
        }
    }

    fn child_needs_attention<T: IsA<gtk::Widget>>(&self, item: &T) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            gtk::ffi::gtk_container_child_get_property(
                self.to_glib_none().0 as *mut gtk::ffi::GtkContainer,
                item.to_glib_none().0 as *mut _,
                b"needs-attention\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `needs-attention` getter")
        }
    }

    fn set_child_needs_attention<T: IsA<gtk::Widget>>(&self, item: &T, needs_attention: bool) {
        unsafe {
            gtk::ffi::gtk_container_child_set_property(
                self.to_glib_none().0 as *mut gtk::ffi::GtkContainer,
                item.to_glib_none().0 as *mut _,
                b"needs-attention\0".as_ptr() as *const _,
                needs_attention.to_value().to_glib_none().0,
            );
        }
    }

    fn child_position<T: IsA<gtk::Widget>>(&self, item: &T) -> i32 {
        unsafe {
            let mut value = glib::Value::from_type(<i32 as StaticType>::static_type());
            gtk::ffi::gtk_container_child_get_property(
                self.to_glib_none().0 as *mut gtk::ffi::GtkContainer,
                item.to_glib_none().0 as *mut _,
                b"position\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `position` getter")
        }
    }

    fn set_child_position<T: IsA<gtk::Widget>>(&self, item: &T, position: i32) {
        unsafe {
            gtk::ffi::gtk_container_child_set_property(
                self.to_glib_none().0 as *mut gtk::ffi::GtkContainer,
                item.to_glib_none().0 as *mut _,
                b"position\0".as_ptr() as *const _,
                position.to_value().to_glib_none().0,
            );
        }
    }

    fn child_title<T: IsA<gtk::Widget>>(&self, item: &T) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            gtk::ffi::gtk_container_child_get_property(
                self.to_glib_none().0 as *mut gtk::ffi::GtkContainer,
                item.to_glib_none().0 as *mut _,
                b"title\0".as_ptr() as *const _,
                value.to_glib_none_mut().0,
            );
            value
                .get()
                .expect("Return Value for property `title` getter")
        }
    }

    fn set_child_title<T: IsA<gtk::Widget>>(&self, item: &T, title: Option<&str>) {
        unsafe {
            gtk::ffi::gtk_container_child_set_property(
                self.to_glib_none().0 as *mut gtk::ffi::GtkContainer,
                item.to_glib_none().0 as *mut _,
                b"title\0".as_ptr() as *const _,
                title.to_value().to_glib_none().0,
            );
        }
    }

    fn connect_can_swipe_back_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_can_swipe_back_trampoline<
            P: IsA<Leaflet>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::can-swipe-back\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_can_swipe_back_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_can_swipe_forward_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_can_swipe_forward_trampoline<
            P: IsA<Leaflet>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::can-swipe-forward\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_can_swipe_forward_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_child_transition_duration_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_child_transition_duration_trampoline<
            P: IsA<Leaflet>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::child-transition-duration\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_child_transition_duration_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_child_transition_running_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_child_transition_running_trampoline<
            P: IsA<Leaflet>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::child-transition-running\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_child_transition_running_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_folded_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_folded_trampoline<P: IsA<Leaflet>, F: Fn(&P) + 'static>(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::folded\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_folded_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_hhomogeneous_folded_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_hhomogeneous_folded_trampoline<
            P: IsA<Leaflet>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::hhomogeneous-folded\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_hhomogeneous_folded_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_hhomogeneous_unfolded_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_hhomogeneous_unfolded_trampoline<
            P: IsA<Leaflet>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::hhomogeneous-unfolded\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_hhomogeneous_unfolded_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_interpolate_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_interpolate_size_trampoline<
            P: IsA<Leaflet>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::interpolate-size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_interpolate_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_mode_transition_duration_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_mode_transition_duration_trampoline<
            P: IsA<Leaflet>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::mode-transition-duration\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_mode_transition_duration_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_transition_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_transition_type_trampoline<
            P: IsA<Leaflet>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::transition-type\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_transition_type_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_vhomogeneous_folded_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_vhomogeneous_folded_trampoline<
            P: IsA<Leaflet>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::vhomogeneous-folded\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_vhomogeneous_folded_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_vhomogeneous_unfolded_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_vhomogeneous_unfolded_trampoline<
            P: IsA<Leaflet>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::vhomogeneous-unfolded\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_vhomogeneous_unfolded_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_visible_child_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_visible_child_trampoline<
            P: IsA<Leaflet>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::visible-child\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_visible_child_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_visible_child_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_visible_child_name_trampoline<
            P: IsA<Leaflet>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::HdyLeaflet,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Leaflet::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::visible-child-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_visible_child_name_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for Leaflet {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Leaflet")
    }
}
