% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistic-udt.R
\name{run_udt}
\alias{run_udt}
\title{Univariate Decision Tree (UDT)}
\usage{
run_udt(
  mat,
  network,
  .source = .data$source,
  .target = .data$target,
  .mor = .data$mor,
  .likelihood = .data$likelihood,
  sparse = FALSE,
  center = FALSE,
  na.rm = FALSE,
  min_n = 20,
  seed = 42,
  minsize = 5
)
}
\arguments{
\item{mat}{Matrix to evaluate (e.g. expression matrix).
Target nodes in rows and conditions in columns.
\code{rownames(mat)} must have at least one intersection with the elements
in \code{network} \code{.target} column.}

\item{network}{Tibble or dataframe with edges and it's associated metadata.}

\item{.source}{Column with source nodes.}

\item{.target}{Column with target nodes.}

\item{.mor}{Column with edge mode of regulation (i.e. mor).}

\item{.likelihood}{Deprecated argument. Now it will always be set to 1.}

\item{sparse}{Deprecated parameter.}

\item{center}{Logical value indicating if \code{mat} must be centered by
\code{\link[base:colSums]{base::rowMeans()}}.}

\item{na.rm}{Should missing values (including NaN) be omitted from the
calculations of \code{\link[base:colSums]{base::rowMeans()}}?}

\item{min_n}{An integer for the minimum number of data points in a node that
are required for the node to be split further.}

\item{seed}{A single value, interpreted as an integer, or NULL for random
number generation.}

\item{minsize}{Integer indicating the minimum number of targets per source.}
}
\value{
A long format tibble of the enrichment scores for each source
across the samples. Resulting tibble contains the following columns:
\enumerate{
\item \code{statistic}: Indicates which method is associated with which score.
\item \code{source}: Source nodes of \code{network}.
\item \code{condition}: Condition representing each column of \code{mat}.
\item \code{score}: Regulatory activity (enrichment score).
}
}
\description{
Calculates regulatory activities by using UDT.
}
\details{
UDT fits a single regression decision tree for each sample and regulator,
where the observed molecular readouts in mat are the response variable and
the regulator weights in net are the explanatory one. Target features with
no associated weight are set to zero. The obtained feature importance from
the fitted model is the activity \code{udt} of a given regulator.
}
\examples{
inputs_dir <- system.file("testdata", "inputs", package = "decoupleR")

mat <- readRDS(file.path(inputs_dir, "mat.rds"))
net <- readRDS(file.path(inputs_dir, "net.rds"))

run_udt(mat, net, minsize=0)
}
\seealso{
Other decoupleR statistics: 
\code{\link{decouple}()},
\code{\link{run_aucell}()},
\code{\link{run_fgsea}()},
\code{\link{run_gsva}()},
\code{\link{run_mdt}()},
\code{\link{run_mlm}()},
\code{\link{run_ora}()},
\code{\link{run_ulm}()},
\code{\link{run_viper}()},
\code{\link{run_wmean}()},
\code{\link{run_wsum}()}
}
\concept{decoupleR statistics}
