"""Generated message classes for developerprojects version v1.

Developer Projects API
"""

from protorpc import messages


package = 'developerprojects'


class DeveloperprojectsProjectsCreateRequest(messages.Message):
  """A DeveloperprojectsProjectsCreateRequest object.

  Fields:
    appengineStorageLocation: The storage location for the AppEngine Project
      Valid options are defined in the StorageLocation enum in
      apphosting/client/services/api/admin.proto
    createAppengineProject: If true, an AppEngine project will be created.
    enableIam: If true, an IAM project will be created.
    project: A Project resource to be passed as the request body.
  """

  appengineStorageLocation = messages.StringField(1)
  createAppengineProject = messages.BooleanField(2, default=True)
  enableIam = messages.BooleanField(3, default=False)
  project = messages.MessageField('Project', 4)


class DeveloperprojectsProjectsGetRequest(messages.Message):
  """A DeveloperprojectsProjectsGetRequest object.

  Fields:
    options_fieldMask: Repeated fields are *fully replaced* with the supplied
      values. Because this behavior is error prone, the APIs should never
      allow updating repeated fields. Instead, repeated fields should be moved
      into their own subcollections.
    projectId: A reference that uniquely identifies the project. This can
      either be the Project.project_id or the Project.project_number. This is
      following the naming PRD at goto/project-naming-prd.
  """

  options_fieldMask = messages.StringField(1)
  projectId = messages.StringField(2, required=True)


class DeveloperprojectsProjectsListRequest(messages.Message):
  """A DeveloperprojectsProjectsListRequest object.

  Fields:
    maxResults: Maximum number of items to return.
    pageToken: A string attribute.
    query: A query expression for filtering the results of the request using
      labels attached to the projects.
    retrievalOptions_fieldMask: Repeated fields are *fully replaced* with the
      supplied values. Because this behavior is error prone, the APIs should
      never allow updating repeated fields. Instead, repeated fields should be
      moved into their own subcollections.
  """

  maxResults = messages.IntegerField(1, variant=messages.Variant.INT32)
  pageToken = messages.StringField(2)
  query = messages.StringField(3)
  retrievalOptions_fieldMask = messages.StringField(4)


class ListProjectsResponse(messages.Message):
  """A page of the response received from the ListProjects method.  A
  paginated response where more pages are available will have
  `next_page_token` set. This token can be used in a subsequent request to
  retrieve the next request page.

  Fields:
    nextPageToken: Pagination token.  If the result set is too large to fit in
      a single response, this token will be filled in. It encodes the position
      of the current result cursor. Feeding this value into a new list request
      as 'page_token' parameter gives the next page of the results.  When
      next_page_token is not filled in, there is no next page and the client
      is looking at the last page in the result set.  Pagination tokens have a
      limited lifetime defined by the service.
    projects: The list of projects that matched the list query, possibly
      paginated.  The resource is partially filled in, based on the
      retrieval_options specified in the `retrieval_options` field of the list
      request.
  """

  nextPageToken = messages.StringField(1)
  projects = messages.MessageField('Project', 2, repeated=True)


class Project(messages.Message):
  """Project message type.

  Enums:
    AbuseStateValueValuesEnum: The abuse subsystem top-level state.  Reports
      whether any known components related to the project have been flagged.
      Should return ABUSE_OK for a project that is in good standing.  If there
      are any components related to the project that are flagged for abuse,
      this should return ABUSE_FLAGGED.  No other detailed abuse status should
      be reported through the projects collection. Detailed abuse status
      reporting should be done via a separate API.  Do not set for
      CreateProject. This field is read only. Updating it has no effect on the
      project state.
    LifecycleStateValueValuesEnum: Retrieves the project lifecycle state.  Do
      not set for CreateProject. This field is read only. Updating it has no
      effect on the project state.

  Fields:
    abuseState: The abuse subsystem top-level state.  Reports whether any
      known components related to the project have been flagged. Should return
      ABUSE_OK for a project that is in good standing.  If there are any
      components related to the project that are flagged for abuse, this
      should return ABUSE_FLAGGED.  No other detailed abuse status should be
      reported through the projects collection. Detailed abuse status
      reporting should be done via a separate API.  Do not set for
      CreateProject. This field is read only. Updating it has no effect on the
      project state.
    appengineName: Important: this is only populated for legacy reasons. No
      new code should use this.  If filled in, the project is known under an
      appengine name. This can uniquely identify a project. Example:
      "s~google.com:foo"  Do not set for CreateProject. This field is read
      only.
    createdMs: Datetime at which the project was created in ms since epoch
    lifecycleState: Retrieves the project lifecycle state.  Do not set for
      CreateProject. This field is read only. Updating it has no effect on the
      project state.
    projectId: The project's user assigned id. This can uniquely identify a
      project. The id must be 6?30 lowercase letters, digits, or hyphens. Must
      start with a letter. Trailing hyphens are prohibited.  Examples: "tokyo-
      rain-123": a consumer project, not bound to a domain. "example.com
      :tokyo-rain-123": a domain-scoped project, scoped to the domain
      `example.com`  Required for CreateProject. This field is read only.
    projectNumber: The project's numeric ID. This is a Gaia ID. This can
      uniquely identify a project.  Example: 415104041262 This is following
      the naming PRD at goto/project-naming-prd.  Do not set for
      CreateProject. This field is read only.
    title: The user-assigned local project title.  Not used for anything
      except pretty displays. Nothing should key off it. Example: "My Project"
      Optional for CreateProject. This is a read-write field. No uniqueness is
      assumed.
  """

  class AbuseStateValueValuesEnum(messages.Enum):
    """The abuse subsystem top-level state.  Reports whether any known
    components related to the project have been flagged. Should return
    ABUSE_OK for a project that is in good standing.  If there are any
    components related to the project that are flagged for abuse, this should
    return ABUSE_FLAGGED.  No other detailed abuse status should be reported
    through the projects collection. Detailed abuse status reporting should be
    done via a separate API.  Do not set for CreateProject. This field is read
    only. Updating it has no effect on the project state.

    Values:
      abuseOk: <no description>
      abuseSuspended: <no description>
      abuseThrottled: <no description>
      abuseUnknown: <no description>
      abuseWarned: <no description>
    """
    abuseOk = 0
    abuseSuspended = 1
    abuseThrottled = 2
    abuseUnknown = 3
    abuseWarned = 4

  class LifecycleStateValueValuesEnum(messages.Enum):
    """Retrieves the project lifecycle state.  Do not set for CreateProject.
    This field is read only. Updating it has no effect on the project state.

    Values:
      lifecycleActive: <no description>
      lifecycleDeleteIrreversible: <no description>
      lifecycleDeleteReversible: <no description>
      lifecycleDeleted: <no description>
      lifecycleUnknown: <no description>
    """
    lifecycleActive = 0
    lifecycleDeleteIrreversible = 1
    lifecycleDeleteReversible = 2
    lifecycleDeleted = 3
    lifecycleUnknown = 4

  abuseState = messages.EnumField('AbuseStateValueValuesEnum', 1)
  appengineName = messages.StringField(2)
  createdMs = messages.IntegerField(3)
  lifecycleState = messages.EnumField('LifecycleStateValueValuesEnum', 4)
  projectId = messages.StringField(5)
  projectNumber = messages.IntegerField(6)
  title = messages.StringField(7)


class StandardQueryParameters(messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    AltValueValuesEnum: Data format for the response.

  Fields:
    alt: Data format for the response.
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters. Overrides userIp if both are provided.
    trace: A tracing token of the form "token:<tokenid>" or "email:<ldap>" to
      include in api requests.
    userIp: IP address of the site where the request originates. Use this if
      you want to enforce per-user limits.
  """

  class AltValueValuesEnum(messages.Enum):
    """Data format for the response.

    Values:
      json: Responses with Content-Type of application/json
    """
    json = 0

  alt = messages.EnumField('AltValueValuesEnum', 1, default=u'json')
  fields = messages.StringField(2)
  key = messages.StringField(3)
  oauth_token = messages.StringField(4)
  prettyPrint = messages.BooleanField(5, default=True)
  quotaUser = messages.StringField(6)
  trace = messages.StringField(7)
  userIp = messages.StringField(8)


