/*
  ==============================================================================

   This file is part of the JUCE library.
   Copyright (c) 2015 - ROLI Ltd.

   Permission is granted to use this software under the terms of either:
   a) the GPL v2 (or any later version)
   b) the Affero GPL v3

   Details of these licenses can be found at: www.gnu.org/licenses

   JUCE is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   ------------------------------------------------------------------------------

   To release a closed-source product which uses JUCE, commercial licenses are
   available: visit www.juce.com for more information.

  ==============================================================================
*/

const Colour Colours::transparentBlack (0);
const Colour Colours::transparentWhite (0x00ffffff);

const Colour Colours::aliceblue (0xfff0f8ff);
const Colour Colours::antiquewhite (0xfffaebd7);
const Colour Colours::aqua (0xff00ffff);
const Colour Colours::aquamarine (0xff7fffd4);
const Colour Colours::azure (0xfff0ffff);
const Colour Colours::beige (0xfff5f5dc);
const Colour Colours::bisque (0xffffe4c4);
const Colour Colours::black (0xff000000);
const Colour Colours::blanchedalmond (0xffffebcd);
const Colour Colours::blue (0xff0000ff);
const Colour Colours::blueviolet (0xff8a2be2);
const Colour Colours::brown (0xffa52a2a);
const Colour Colours::burlywood (0xffdeb887);
const Colour Colours::cadetblue (0xff5f9ea0);
const Colour Colours::chartreuse (0xff7fff00);
const Colour Colours::chocolate (0xffd2691e);
const Colour Colours::coral (0xffff7f50);
const Colour Colours::cornflowerblue (0xff6495ed);
const Colour Colours::cornsilk (0xfffff8dc);
const Colour Colours::crimson (0xffdc143c);
const Colour Colours::cyan (0xff00ffff);
const Colour Colours::darkblue (0xff00008b);
const Colour Colours::darkcyan (0xff008b8b);
const Colour Colours::darkgoldenrod (0xffb8860b);
const Colour Colours::darkgrey (0xff555555);
const Colour Colours::darkgreen (0xff006400);
const Colour Colours::darkkhaki (0xffbdb76b);
const Colour Colours::darkmagenta (0xff8b008b);
const Colour Colours::darkolivegreen (0xff556b2f);
const Colour Colours::darkorange (0xffff8c00);
const Colour Colours::darkorchid (0xff9932cc);
const Colour Colours::darkred (0xff8b0000);
const Colour Colours::darksalmon (0xffe9967a);
const Colour Colours::darkseagreen (0xff8fbc8f);
const Colour Colours::darkslateblue (0xff483d8b);
const Colour Colours::darkslategrey (0xff2f4f4f);
const Colour Colours::darkturquoise (0xff00ced1);
const Colour Colours::darkviolet (0xff9400d3);
const Colour Colours::deeppink (0xffff1493);
const Colour Colours::deepskyblue (0xff00bfff);
const Colour Colours::dimgrey (0xff696969);
const Colour Colours::dodgerblue (0xff1e90ff);
const Colour Colours::firebrick (0xffb22222);
const Colour Colours::floralwhite (0xfffffaf0);
const Colour Colours::forestgreen (0xff228b22);
const Colour Colours::fuchsia (0xffff00ff);
const Colour Colours::gainsboro (0xffdcdcdc);
const Colour Colours::gold (0xffffd700);
const Colour Colours::goldenrod (0xffdaa520);
const Colour Colours::grey (0xff808080);
const Colour Colours::green (0xff008000);
const Colour Colours::greenyellow (0xffadff2f);
const Colour Colours::honeydew (0xfff0fff0);
const Colour Colours::hotpink (0xffff69b4);
const Colour Colours::indianred (0xffcd5c5c);
const Colour Colours::indigo (0xff4b0082);
const Colour Colours::ivory (0xfffffff0);
const Colour Colours::khaki (0xfff0e68c);
const Colour Colours::lavender (0xffe6e6fa);
const Colour Colours::lavenderblush (0xfffff0f5);
const Colour Colours::lemonchiffon (0xfffffacd);
const Colour Colours::lightblue (0xffadd8e6);
const Colour Colours::lightcoral (0xfff08080);
const Colour Colours::lightcyan (0xffe0ffff);
const Colour Colours::lightgoldenrodyellow (0xfffafad2);
const Colour Colours::lightgreen (0xff90ee90);
const Colour Colours::lightgrey (0xffd3d3d3);
const Colour Colours::lightpink (0xffffb6c1);
const Colour Colours::lightsalmon (0xffffa07a);
const Colour Colours::lightseagreen (0xff20b2aa);
const Colour Colours::lightskyblue (0xff87cefa);
const Colour Colours::lightslategrey (0xff778899);
const Colour Colours::lightsteelblue (0xffb0c4de);
const Colour Colours::lightyellow (0xffffffe0);
const Colour Colours::lime (0xff00ff00);
const Colour Colours::limegreen (0xff32cd32);
const Colour Colours::linen (0xfffaf0e6);
const Colour Colours::magenta (0xffff00ff);
const Colour Colours::maroon (0xff800000);
const Colour Colours::mediumaquamarine (0xff66cdaa);
const Colour Colours::mediumblue (0xff0000cd);
const Colour Colours::mediumorchid (0xffba55d3);
const Colour Colours::mediumpurple (0xff9370db);
const Colour Colours::mediumseagreen (0xff3cb371);
const Colour Colours::mediumslateblue (0xff7b68ee);
const Colour Colours::mediumspringgreen (0xff00fa9a);
const Colour Colours::mediumturquoise (0xff48d1cc);
const Colour Colours::mediumvioletred (0xffc71585);
const Colour Colours::midnightblue (0xff191970);
const Colour Colours::mintcream (0xfff5fffa);
const Colour Colours::mistyrose (0xffffe4e1);
const Colour Colours::navajowhite (0xffffdead);
const Colour Colours::navy (0xff000080);
const Colour Colours::oldlace (0xfffdf5e6);
const Colour Colours::olive (0xff808000);
const Colour Colours::olivedrab (0xff6b8e23);
const Colour Colours::orange (0xffffa500);
const Colour Colours::orangered (0xffff4500);
const Colour Colours::orchid (0xffda70d6);
const Colour Colours::palegoldenrod (0xffeee8aa);
const Colour Colours::palegreen (0xff98fb98);
const Colour Colours::paleturquoise (0xffafeeee);
const Colour Colours::palevioletred (0xffdb7093);
const Colour Colours::papayawhip (0xffffefd5);
const Colour Colours::peachpuff (0xffffdab9);
const Colour Colours::peru (0xffcd853f);
const Colour Colours::pink (0xffffc0cb);
const Colour Colours::plum (0xffdda0dd);
const Colour Colours::powderblue (0xffb0e0e6);
const Colour Colours::purple (0xff800080);
const Colour Colours::red (0xffff0000);
const Colour Colours::rosybrown (0xffbc8f8f);
const Colour Colours::royalblue (0xff4169e1);
const Colour Colours::saddlebrown (0xff8b4513);
const Colour Colours::salmon (0xfffa8072);
const Colour Colours::sandybrown (0xfff4a460);
const Colour Colours::seagreen (0xff2e8b57);
const Colour Colours::seashell (0xfffff5ee);
const Colour Colours::sienna (0xffa0522d);
const Colour Colours::silver (0xffc0c0c0);
const Colour Colours::skyblue (0xff87ceeb);
const Colour Colours::slateblue (0xff6a5acd);
const Colour Colours::slategrey (0xff708090);
const Colour Colours::snow (0xfffffafa);
const Colour Colours::springgreen (0xff00ff7f);
const Colour Colours::steelblue (0xff4682b4);
const Colour Colours::tan (0xffd2b48c);
const Colour Colours::teal (0xff008080);
const Colour Colours::thistle (0xffd8bfd8);
const Colour Colours::tomato (0xffff6347);
const Colour Colours::turquoise (0xff40e0d0);
const Colour Colours::violet (0xffee82ee);
const Colour Colours::wheat (0xfff5deb3);
const Colour Colours::white (0xffffffff);
const Colour Colours::whitesmoke (0xfff5f5f5);
const Colour Colours::yellow (0xffffff00);
const Colour Colours::yellowgreen (0xff9acd32);

//==============================================================================
Colour Colours::findColourForName (const String& colourName,
                                   Colour defaultColour)
{
    static const uint32 presets[] =
    {
        // (first value is the string's hashcode, second is ARGB)

        0x05978fff, 0xff000000, /* black */
        0x06bdcc29, 0xffffffff, /* white */
        0x002e305a, 0xff0000ff, /* blue */
        0x00308adf, 0xff808080, /* grey */
        0x05e0cf03, 0xff008000, /* green */
        0x0001b891, 0xffff0000, /* red */
        0xd43c6474, 0xffffff00, /* yellow */
        0x620886da, 0xfff0f8ff, /* aliceblue */
        0x20a2676a, 0xfffaebd7, /* antiquewhite */
        0x002dcebc, 0xff00ffff, /* aqua */
        0x46bb5f7e, 0xff7fffd4, /* aquamarine */
        0x0590228f, 0xfff0ffff, /* azure */
        0x05947fe4, 0xfff5f5dc, /* beige */
        0xad388e35, 0xffffe4c4, /* bisque */
        0x00674f7e, 0xffffebcd, /* blanchedalmond */
        0x39129959, 0xff8a2be2, /* blueviolet */
        0x059a8136, 0xffa52a2a, /* brown */
        0x89cea8f9, 0xffdeb887, /* burlywood */
        0x0fa260cf, 0xff5f9ea0, /* cadetblue */
        0x6b748956, 0xff7fff00, /* chartreuse */
        0x2903623c, 0xffd2691e, /* chocolate */
        0x05a74431, 0xffff7f50, /* coral */
        0x618d42dd, 0xff6495ed, /* cornflowerblue */
        0xe4b479fd, 0xfffff8dc, /* cornsilk */
        0x3d8c4edf, 0xffdc143c, /* crimson */
        0x002ed323, 0xff00ffff, /* cyan */
        0x67cc74d0, 0xff00008b, /* darkblue */
        0x67cd1799, 0xff008b8b, /* darkcyan */
        0x31bbd168, 0xffb8860b, /* darkgoldenrod */
        0x67cecf55, 0xff555555, /* darkgrey */
        0x920b194d, 0xff006400, /* darkgreen */
        0x923edd4c, 0xffbdb76b, /* darkkhaki */
        0x5c293873, 0xff8b008b, /* darkmagenta */
        0x6b6671fe, 0xff556b2f, /* darkolivegreen */
        0xbcfd2524, 0xffff8c00, /* darkorange */
        0xbcfdf799, 0xff9932cc, /* darkorchid */
        0x55ee0d5b, 0xff8b0000, /* darkred */
        0xc2e5f564, 0xffe9967a, /* darksalmon */
        0x61be858a, 0xff8fbc8f, /* darkseagreen */
        0xc2b0f2bd, 0xff483d8b, /* darkslateblue */
        0xc2b34d42, 0xff2f4f4f, /* darkslategrey */
        0x7cf2b06b, 0xff00ced1, /* darkturquoise */
        0xc8769375, 0xff9400d3, /* darkviolet */
        0x25832862, 0xffff1493, /* deeppink */
        0xfcad568f, 0xff00bfff, /* deepskyblue */
        0x634c8b67, 0xff696969, /* dimgrey */
        0x45c1ce55, 0xff1e90ff, /* dodgerblue */
        0xef19e3cb, 0xffb22222, /* firebrick */
        0xb852b195, 0xfffffaf0, /* floralwhite */
        0xd086fd06, 0xff228b22, /* forestgreen */
        0xe106b6d7, 0xffff00ff, /* fuchsia */
        0x7880d61e, 0xffdcdcdc, /* gainsboro */
        0x00308060, 0xffffd700, /* gold */
        0xb3b3bc1e, 0xffdaa520, /* goldenrod */
        0xbab8a537, 0xffadff2f, /* greenyellow */
        0xe4cacafb, 0xfff0fff0, /* honeydew */
        0x41892743, 0xffff69b4, /* hotpink */
        0xd5796f1a, 0xffcd5c5c, /* indianred */
        0xb969fed2, 0xff4b0082, /* indigo */
        0x05fef6a9, 0xfffffff0, /* ivory */
        0x06149302, 0xfff0e68c, /* khaki */
        0xad5a05c7, 0xffe6e6fa, /* lavender */
        0x7c4d5b99, 0xfffff0f5, /* lavenderblush */
        0x195756f0, 0xfffffacd, /* lemonchiffon */
        0x28e4ea70, 0xffadd8e6, /* lightblue */
        0xf3c7ccdb, 0xfff08080, /* lightcoral */
        0x28e58d39, 0xffe0ffff, /* lightcyan */
        0x21234e3c, 0xfffafad2, /* lightgoldenrodyellow */
        0xf40157ad, 0xff90ee90, /* lightgreen */
        0x28e744f5, 0xffd3d3d3, /* lightgrey */
        0x28eb3b8c, 0xffffb6c1, /* lightpink */
        0x9fb78304, 0xffffa07a, /* lightsalmon */
        0x50632b2a, 0xff20b2aa, /* lightseagreen */
        0x68fb7b25, 0xff87cefa, /* lightskyblue */
        0xa8a35ba2, 0xff778899, /* lightslategrey */
        0xa20d484f, 0xffb0c4de, /* lightsteelblue */
        0xaa2cf10a, 0xffffffe0, /* lightyellow */
        0x0032afd5, 0xff00ff00, /* lime */
        0x607bbc4e, 0xff32cd32, /* limegreen */
        0x06234efa, 0xfffaf0e6, /* linen */
        0x316858a9, 0xffff00ff, /* magenta */
        0xbf8ca470, 0xff800000, /* maroon */
        0xbd58e0b3, 0xff66cdaa, /* mediumaquamarine */
        0x967dfd4f, 0xff0000cd, /* mediumblue */
        0x056f5c58, 0xffba55d3, /* mediumorchid */
        0x07556b71, 0xff9370db, /* mediumpurple */
        0x5369b689, 0xff3cb371, /* mediumseagreen */
        0x066be19e, 0xff7b68ee, /* mediumslateblue */
        0x3256b281, 0xff00fa9a, /* mediumspringgreen */
        0xc0ad9f4c, 0xff48d1cc, /* mediumturquoise */
        0x628e63dd, 0xffc71585, /* mediumvioletred */
        0x168eb32a, 0xff191970, /* midnightblue */
        0x4306b960, 0xfff5fffa, /* mintcream */
        0x4cbc0e6b, 0xffffe4e1, /* mistyrose */
        0xe97218a6, 0xffffdead, /* navajowhite */
        0x00337bb6, 0xff000080, /* navy */
        0xadd2d33e, 0xfffdf5e6, /* oldlace */
        0x064ee1db, 0xff808000, /* olive */
        0x9e33a98a, 0xff6b8e23, /* olivedrab */
        0xc3de262e, 0xffffa500, /* orange */
        0x58bebba3, 0xffff4500, /* orangered */
        0xc3def8a3, 0xffda70d6, /* orchid */
        0x28cb4834, 0xffeee8aa, /* palegoldenrod */
        0x3d9dd619, 0xff98fb98, /* palegreen */
        0x74022737, 0xffafeeee, /* paleturquoise */
        0x15e2ebc8, 0xffdb7093, /* palevioletred */
        0x5fd898e2, 0xffffefd5, /* papayawhip */
        0x93e1b776, 0xffffdab9, /* peachpuff */
        0x003472f8, 0xffcd853f, /* peru */
        0x00348176, 0xffffc0cb, /* pink */
        0x00348d94, 0xffdda0dd, /* plum */
        0xd036be93, 0xffb0e0e6, /* powderblue */
        0xc5c507bc, 0xff800080, /* purple */
        0xa89d65b3, 0xffbc8f8f, /* rosybrown */
        0xbd9413e1, 0xff4169e1, /* royalblue */
        0xf456044f, 0xff8b4513, /* saddlebrown */
        0xc9c6f66e, 0xfffa8072, /* salmon */
        0x0bb131e1, 0xfff4a460, /* sandybrown */
        0x34636c14, 0xff2e8b57, /* seagreen */
        0x3507fb41, 0xfffff5ee, /* seashell */
        0xca348772, 0xffa0522d, /* sienna */
        0xca37d30d, 0xffc0c0c0, /* silver */
        0x80da74fb, 0xff87ceeb, /* skyblue */
        0x44a8dd73, 0xff6a5acd, /* slateblue */
        0x44ab37f8, 0xff708090, /* slategrey */
        0x0035f183, 0xfffffafa, /* snow */
        0xd5440d16, 0xff00ff7f, /* springgreen */
        0x3e1524a5, 0xff4682b4, /* steelblue */
        0x0001bfa1, 0xffd2b48c, /* tan */
        0x0036425c, 0xff008080, /* teal */
        0xafc8858f, 0xffd8bfd8, /* thistle */
        0xcc41600a, 0xffff6347, /* tomato */
        0xfeea9b21, 0xff40e0d0, /* turquoise */
        0xcf57947f, 0xffee82ee, /* violet */
        0x06bdbae7, 0xfff5deb3, /* wheat */
        0x10802ee6, 0xfff5f5f5, /* whitesmoke */
        0xe1b5130f, 0xff9acd32  /* yellowgreen */
    };

    const uint32 hash = (uint32) colourName.trim().toLowerCase().hashCode();

    for (int i = 0; i < numElementsInArray (presets); i += 2)
        if (presets [i] == hash)
            return Colour (presets [i + 1]);

    return defaultColour;
}
