/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.DirectorySignature;
import org.torproject.descriptor.impl.DescriptorImpl;
import org.torproject.descriptor.impl.Key;
import org.torproject.descriptor.impl.ParseHelper;

public class DirectorySignatureImpl
implements DirectorySignature {
    private DescriptorImpl parent;
    private int offset;
    private int length;
    private List<String> unrecognizedLines;
    static final String DEFAULT_ALGORITHM = "sha1";
    private String algorithm;
    private String identity;
    private String signingKeyDigest;
    private String signature;

    protected List<String> getAndClearUnrecognizedLines() {
        List<String> lines = this.unrecognizedLines;
        this.unrecognizedLines = null;
        return lines;
    }

    protected DirectorySignatureImpl(DescriptorImpl parent, int offset, int length) throws DescriptorParseException {
        this.parent = parent;
        this.offset = offset;
        this.length = length;
        this.parseDirectorySignatureBytes();
    }

    private void parseDirectorySignatureBytes() throws DescriptorParseException {
        Scanner scanner = this.parent.newScanner(this.offset, this.length).useDelimiter("\n");
        StringBuilder crypto = null;
        block9: while (scanner.hasNext()) {
            String line = scanner.next();
            String[] parts = line.split(" ", -1);
            Key key = Key.get(parts[0]);
            switch (key) {
                case DIRECTORY_SIGNATURE: {
                    int algorithmOffset = 0;
                    switch (parts.length) {
                        case 4: {
                            this.algorithm = parts[1];
                            algorithmOffset = 1;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw new DescriptorParseException("Illegal line '" + line + "'.");
                        }
                    }
                    this.identity = ParseHelper.parseHexString(line, parts[1 + algorithmOffset]);
                    this.signingKeyDigest = ParseHelper.parseHexString(line, parts[2 + algorithmOffset]);
                    continue block9;
                }
                case CRYPTO_BEGIN: {
                    crypto = new StringBuilder();
                    crypto.append(line).append("\n");
                    continue block9;
                }
                case CRYPTO_END: {
                    if (null == crypto) {
                        throw new DescriptorParseException((Object)((Object)Key.CRYPTO_END) + " before " + (Object)((Object)Key.CRYPTO_BEGIN));
                    }
                    crypto.append(line).append("\n");
                    String cryptoString = crypto.toString();
                    crypto = null;
                    this.signature = cryptoString;
                    continue block9;
                }
            }
            if (crypto != null) {
                crypto.append(line).append("\n");
                continue;
            }
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList<String>();
            }
            this.unrecognizedLines.add(line);
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm == null ? DEFAULT_ALGORITHM : this.algorithm;
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public String getSigningKeyDigestSha1Hex() {
        return this.signingKeyDigest;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }
}

