/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Scanner;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.RelayDirectory;
import org.torproject.descriptor.RouterStatusEntry;
import org.torproject.descriptor.ServerDescriptor;
import org.torproject.descriptor.impl.DescriptorImpl;
import org.torproject.descriptor.impl.Key;
import org.torproject.descriptor.impl.ParseHelper;
import org.torproject.descriptor.impl.RelayServerDescriptorImpl;
import org.torproject.descriptor.impl.RouterStatusEntryImpl;

public class RelayDirectoryImpl
extends DescriptorImpl
implements RelayDirectory {
    private long publishedMillis;
    private String dirSigningKey;
    private List<String> recommendedSoftware;
    private String directorySignature;
    private List<RouterStatusEntry> statusEntries = new ArrayList<RouterStatusEntry>();
    private List<ServerDescriptor> serverDescriptors = new ArrayList<ServerDescriptor>();
    private List<Exception> serverDescriptorParseExceptions = new ArrayList<Exception>();
    private String nickname;

    protected RelayDirectoryImpl(byte[] directoryBytes, int[] offsetAndLength, File descriptorFile) throws DescriptorParseException {
        super(directoryBytes, offsetAndLength, descriptorFile, true);
        this.splitAndParseParts();
        this.calculateDigestSha1Hex(Key.SIGNED_DIRECTORY.keyword + "\n", "\n" + Key.DIRECTORY_SIGNATURE.keyword + " ");
        EnumSet<Key> exactlyOnceKeys = EnumSet.of(Key.SIGNED_DIRECTORY, Key.RECOMMENDED_SOFTWARE, Key.DIRECTORY_SIGNATURE);
        this.checkExactlyOnceKeys(exactlyOnceKeys);
        EnumSet<Key> atMostOnceKeys = EnumSet.of(Key.DIR_SIGNING_KEY, Key.RUNNING_ROUTERS, Key.ROUTER_STATUS);
        this.checkAtMostOnceKeys(atMostOnceKeys);
        this.checkFirstKey(Key.SIGNED_DIRECTORY);
        this.clearParsedKeys();
    }

    private void splitAndParseParts() throws DescriptorParseException {
        int startIndex = 0;
        int firstRouterIndex = this.findFirstIndexOfKey(Key.ROUTER);
        int directorySignatureIndex = this.findFirstIndexOfKey(Key.DIRECTORY_SIGNATURE);
        int endIndex = this.offset + this.length;
        if (directorySignatureIndex < 0) {
            directorySignatureIndex = endIndex;
        }
        if (firstRouterIndex < 0) {
            firstRouterIndex = directorySignatureIndex;
        }
        if (firstRouterIndex > startIndex) {
            this.parseHeader(startIndex, firstRouterIndex - startIndex);
        }
        if (directorySignatureIndex > firstRouterIndex) {
            this.parseServerDescriptors(firstRouterIndex, directorySignatureIndex - firstRouterIndex);
        }
        if (endIndex > directorySignatureIndex) {
            this.parseDirectorySignatures(directorySignatureIndex, endIndex - directorySignatureIndex);
        }
    }

    private void parseServerDescriptors(int offset, int length) {
        List<int[]> offsetsAndLengths = this.splitByKey(Key.ROUTER, offset, length, true);
        for (int[] offsetAndLength : offsetsAndLengths) {
            this.parseServerDescriptor(offsetAndLength[0], offsetAndLength[1]);
        }
    }

    private void parseDirectorySignatures(int offset, int length) throws DescriptorParseException {
        List<int[]> offsetsAndLengths = this.splitByKey(Key.DIRECTORY_SIGNATURE, offset, length, false);
        for (int[] offsetAndLength : offsetsAndLengths) {
            this.parseDirectorySignature(offsetAndLength[0], offsetAndLength[1]);
        }
    }

    private void parseHeader(int offset, int length) throws DescriptorParseException {
        Scanner scanner = this.newScanner(offset, length).useDelimiter("\n");
        String publishedLine = null;
        Key nextCrypto = Key.EMPTY;
        String runningRoutersLine = null;
        String routerStatusLine = null;
        StringBuilder crypto = null;
        block10: while (scanner.hasNext()) {
            String line = scanner.next();
            if (line.isEmpty() || line.startsWith("@")) continue;
            String lineNoOpt = line.startsWith(Key.OPT.keyword + " ") ? line.substring(Key.OPT.keyword.length() + 1) : line;
            String[] partsNoOpt = lineNoOpt.split("[ \t]+");
            Key key = Key.get(partsNoOpt[0]);
            switch (key) {
                case SIGNED_DIRECTORY: {
                    this.parseSignedDirectoryLine(line, lineNoOpt);
                    continue block10;
                }
                case PUBLISHED: {
                    if (publishedLine != null) {
                        throw new DescriptorParseException("Keyword 'published' is contained more than once, but must be contained exactly once.");
                    }
                    publishedLine = line;
                    continue block10;
                }
                case DIR_SIGNING_KEY: {
                    this.parseDirSigningKeyLine(line, partsNoOpt);
                    nextCrypto = key;
                    continue block10;
                }
                case RECOMMENDED_SOFTWARE: {
                    this.parseRecommendedSoftwareLine(line, partsNoOpt);
                    continue block10;
                }
                case RUNNING_ROUTERS: {
                    runningRoutersLine = line;
                    continue block10;
                }
                case ROUTER_STATUS: {
                    routerStatusLine = line;
                    continue block10;
                }
                case CRYPTO_BEGIN: {
                    crypto = new StringBuilder();
                    crypto.append(line).append("\n");
                    continue block10;
                }
                case CRYPTO_END: {
                    if (null == crypto) {
                        throw new DescriptorParseException((Object)((Object)Key.CRYPTO_END) + " before " + (Object)((Object)Key.CRYPTO_BEGIN));
                    }
                    crypto.append(line).append("\n");
                    String cryptoString = crypto.toString();
                    crypto = null;
                    if (!nextCrypto.equals((Object)Key.DIR_SIGNING_KEY) || this.dirSigningKey != null) {
                        throw new DescriptorParseException("Unrecognized crypto block in v1 directory.");
                    }
                    this.dirSigningKey = cryptoString;
                    nextCrypto = Key.EMPTY;
                    continue block10;
                }
            }
            if (crypto != null) {
                crypto.append(line).append("\n");
                continue;
            }
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.add(line);
        }
        if (publishedLine == null) {
            throw new DescriptorParseException("Keyword 'published' is contained 0 times, but must be contained exactly once.");
        }
        String publishedLineNoOpt = publishedLine.startsWith(Key.OPT.keyword + " ") ? publishedLine.substring(Key.OPT.keyword.length() + 1) : publishedLine;
        String[] publishedPartsNoOpt = publishedLineNoOpt.split("[ \t]+");
        this.parsePublishedLine(publishedLine, publishedPartsNoOpt);
        if (routerStatusLine != null) {
            String routerStatusLineNoOpt = routerStatusLine.startsWith(Key.OPT.keyword + " ") ? routerStatusLine.substring(Key.OPT.keyword.length() + 1) : routerStatusLine;
            String[] routerStatusPartsNoOpt = routerStatusLineNoOpt.split("[ \t]+");
            this.parseRouterStatusLine(routerStatusPartsNoOpt);
        } else if (runningRoutersLine != null) {
            String runningRoutersLineNoOpt = runningRoutersLine.startsWith(Key.OPT.keyword + " ") ? runningRoutersLine.substring(Key.OPT.keyword.length() + 1) : runningRoutersLine;
            String[] runningRoutersPartsNoOpt = runningRoutersLineNoOpt.split("[ \t]+");
            this.parseRunningRoutersLine(runningRoutersPartsNoOpt);
        } else {
            throw new DescriptorParseException("Either running-routers or router-status line must be given.");
        }
    }

    protected void parseServerDescriptor(int offset, int length) {
        try {
            RelayServerDescriptorImpl serverDescriptor = new RelayServerDescriptorImpl(this.rawDescriptorBytes, new int[]{offset, length}, this.getDescriptorFile());
            this.serverDescriptors.add(serverDescriptor);
        }
        catch (DescriptorParseException e) {
            this.serverDescriptorParseExceptions.add(e);
        }
    }

    private void parseDirectorySignature(int offset, int length) throws DescriptorParseException {
        Scanner scanner = this.newScanner(offset, length).useDelimiter("\n");
        Key nextCrypto = Key.EMPTY;
        StringBuilder crypto = null;
        block5: while (scanner.hasNext()) {
            String line = scanner.next();
            String lineNoOpt = line.startsWith(Key.OPT.keyword + " ") ? line.substring(Key.OPT.keyword.length() + 1) : line;
            String[] partsNoOpt = lineNoOpt.split("[ \t]+");
            Key key = Key.get(partsNoOpt[0]);
            switch (key) {
                case DIRECTORY_SIGNATURE: {
                    this.parseDirectorySignatureLine(line, partsNoOpt);
                    nextCrypto = key;
                    continue block5;
                }
                case CRYPTO_BEGIN: {
                    crypto = new StringBuilder();
                    crypto.append(line).append("\n");
                    continue block5;
                }
                case CRYPTO_END: {
                    if (null == crypto) {
                        throw new DescriptorParseException((Object)((Object)Key.CRYPTO_END) + " before " + (Object)((Object)Key.CRYPTO_BEGIN));
                    }
                    crypto.append(line).append("\n");
                    String cryptoString = crypto.toString();
                    crypto = null;
                    if (!nextCrypto.equals((Object)Key.DIRECTORY_SIGNATURE)) {
                        throw new DescriptorParseException("Unrecognized crypto block in v2 network status.");
                    }
                    this.directorySignature = cryptoString;
                    nextCrypto = Key.EMPTY;
                    continue block5;
                }
            }
            if (crypto != null) {
                crypto.append(line).append("\n");
                continue;
            }
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.add(line);
        }
    }

    private void parseSignedDirectoryLine(String line, String lineNoOpt) throws DescriptorParseException {
        if (!lineNoOpt.equals(Key.SIGNED_DIRECTORY.keyword)) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
    }

    private void parsePublishedLine(String line, String[] partsNoOpt) throws DescriptorParseException {
        this.publishedMillis = ParseHelper.parseTimestampAtIndex(line, partsNoOpt, 1, 2);
    }

    private void parseDirSigningKeyLine(String line, String[] partsNoOpt) throws DescriptorParseException {
        if (partsNoOpt.length > 2) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        if (partsNoOpt.length == 2) {
            StringBuilder sb = new StringBuilder();
            sb.append("-----BEGIN RSA PUBLIC KEY-----\n");
            String keyString = partsNoOpt[1];
            while (keyString.length() > 64) {
                sb.append(keyString, 0, 64).append("\n");
                keyString = keyString.substring(64);
            }
            if (keyString.length() > 0) {
                sb.append(keyString).append("\n");
            }
            sb.append("-----END RSA PUBLIC KEY-----\n");
            this.dirSigningKey = sb.toString();
        }
    }

    private void parseRecommendedSoftwareLine(String line, String[] partsNoOpt) throws DescriptorParseException {
        ArrayList<String> result = new ArrayList<String>();
        if (partsNoOpt.length > 2) {
            throw new DescriptorParseException("Illegal versions line '" + line + "'.");
        }
        if (partsNoOpt.length == 2) {
            String[] versions;
            for (String version : versions = partsNoOpt[1].split(",", -1)) {
                if (version.length() < 1) {
                    throw new DescriptorParseException("Illegal versions line '" + line + "'.");
                }
                result.add(version);
            }
        }
        this.recommendedSoftware = result;
    }

    private void parseRunningRoutersLine(String[] partsNoOpt) throws DescriptorParseException {
        for (int i = 1; i < partsNoOpt.length; ++i) {
            boolean isVerified;
            String part = partsNoOpt[i];
            String debugLine = "running-routers [...] " + part + " [...]";
            boolean isLive = true;
            if (part.startsWith("!")) {
                isLive = false;
                part = part.substring(1);
            }
            String fingerprint = null;
            String nickname = null;
            if (part.startsWith("$")) {
                isVerified = false;
                fingerprint = ParseHelper.parseTwentyByteHexString(debugLine, part.substring(1));
            } else {
                isVerified = true;
                nickname = ParseHelper.parseNickname(debugLine, part);
            }
            this.statusEntries.add(new RouterStatusEntryImpl(fingerprint, nickname, isLive, isVerified));
        }
    }

    private void parseRouterStatusLine(String[] partsNoOpt) throws DescriptorParseException {
        for (int i = 1; i < partsNoOpt.length; ++i) {
            String part = partsNoOpt[i];
            String debugLine = "router-status [...] " + part + " [...]";
            RouterStatusEntryImpl entry = null;
            if (part.contains("=")) {
                String[] partParts = part.split("=");
                if (partParts.length == 2) {
                    String nickname;
                    boolean isLive;
                    boolean isVerified = true;
                    if (partParts[0].startsWith("!")) {
                        isLive = false;
                        nickname = ParseHelper.parseNickname(debugLine, partParts[0].substring(1));
                    } else {
                        isLive = true;
                        nickname = ParseHelper.parseNickname(debugLine, partParts[0]);
                    }
                    String fingerprint = ParseHelper.parseTwentyByteHexString(debugLine, partParts[1].substring(1));
                    entry = new RouterStatusEntryImpl(fingerprint, nickname, isLive, isVerified);
                }
            } else {
                String fingerprint;
                boolean isLive;
                boolean isVerified = false;
                String nickname = null;
                if (part.startsWith("!")) {
                    isLive = false;
                    fingerprint = ParseHelper.parseTwentyByteHexString(debugLine, part.substring(2));
                } else {
                    isLive = true;
                    fingerprint = ParseHelper.parseTwentyByteHexString(debugLine, part.substring(1));
                }
                entry = new RouterStatusEntryImpl(fingerprint, nickname, isLive, isVerified);
            }
            if (entry == null) {
                throw new DescriptorParseException("Illegal router-status entry '" + part + "' in v1 directory.");
            }
            this.statusEntries.add(entry);
        }
    }

    private void parseDirectorySignatureLine(String line, String[] partsNoOpt) throws DescriptorParseException {
        if (partsNoOpt.length < 2) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        this.nickname = ParseHelper.parseNickname(line, partsNoOpt[1]);
    }

    @Override
    public long getPublishedMillis() {
        return this.publishedMillis;
    }

    @Override
    public String getDirSigningKey() {
        return this.dirSigningKey;
    }

    @Override
    public List<String> getRecommendedSoftware() {
        return this.recommendedSoftware == null ? null : new ArrayList<String>(this.recommendedSoftware);
    }

    @Override
    public String getDirectorySignature() {
        return this.directorySignature;
    }

    @Override
    public List<RouterStatusEntry> getRouterStatusEntries() {
        return new ArrayList<RouterStatusEntry>(this.statusEntries);
    }

    @Override
    public List<ServerDescriptor> getServerDescriptors() {
        return new ArrayList<ServerDescriptor>(this.serverDescriptors);
    }

    @Override
    public List<Exception> getServerDescriptorParseExceptions() {
        return new ArrayList<Exception>(this.serverDescriptorParseExceptions);
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }
}

