/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.regex.Pattern;

public final class MutableExceptionCheck
extends AbstractCheck {
    public static final String MSG_KEY = "mutable.exception";
    private static final String DEFAULT_FORMAT = "^.*Exception$|^.*Error$|^.*Throwable$";
    private final Deque<Boolean> checkingStack = new ArrayDeque<Boolean>();
    private String extendedClassNameFormat = "^.*Exception$|^.*Error$|^.*Throwable$";
    private boolean checking;
    private String format = "^.*Exception$|^.*Error$|^.*Throwable$";
    private Pattern regexp = Pattern.compile(this.format);

    public void setExtendedClassNameFormat(String extendedClassNameFormat) {
        this.extendedClassNameFormat = extendedClassNameFormat;
    }

    public void setFormat(String format) {
        this.format = format;
        this.regexp = CommonUtils.createPattern(format);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{14, 10};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{14, 10};
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 14: {
                this.visitClassDef(ast);
                break;
            }
            case 10: {
                this.visitVariableDef(ast);
                break;
            }
            default: {
                throw new IllegalStateException(ast.toString());
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        if (ast.getType() == 14) {
            this.leaveClassDef();
        }
    }

    private void visitClassDef(DetailAST ast) {
        this.checkingStack.push(this.checking);
        this.checking = this.isNamedAsException(ast) && this.isExtendedClassNamedAsException(ast);
    }

    private void leaveClassDef() {
        this.checking = this.checkingStack.pop();
    }

    private void visitVariableDef(DetailAST ast) {
        DetailAST modifiersAST;
        if (this.checking && ast.getParent().getType() == 6 && (modifiersAST = ast.findFirstToken(5)).findFirstToken(39) == null) {
            this.log(ast.getLineNo(), ast.getColumnNo(), MSG_KEY, ast.findFirstToken(58).getText());
        }
    }

    private boolean isNamedAsException(DetailAST ast) {
        String className = ast.findFirstToken(58).getText();
        return this.regexp.matcher(className).find();
    }

    private boolean isExtendedClassNamedAsException(DetailAST ast) {
        DetailAST extendsClause = ast.findFirstToken(18);
        if (extendsClause != null) {
            DetailAST currentNode = extendsClause;
            while (currentNode.getLastChild() != null) {
                currentNode = currentNode.getLastChild();
            }
            String extendedClassName = currentNode.getText();
            return extendedClassName.matches(this.extendedClassNameFormat);
        }
        return false;
    }
}

