/* 
 *  Copyright (C) 1999-2000 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#ifndef _WEBSEARCH_H_
#define _WEBSEARCH_H_


#include <qstringlist.h>
#include "searchjob.h"
class WebSite;
class SiteManager;


class WebSiteManager
{
public:
    WebSiteManager();
    ~WebSiteManager();
    WebSite *find(const QString &name);
    QStringList siteList();

private:
    SiteManager *d;
};


class WebSearch : public SearchJob
{
    Q_OBJECT
    
public:
    WebSearch(WebSite *site, const QString &searchtext);
    
signals:
    void foundItem(const QString &sitename, const QString &title,
                   const QString &url, int relevance, const QString &details);

protected:
    virtual void parseItem(const QString &item);
};

#endif 
