/* 
 *  Copyright (C) 1999-2000 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#ifndef _FTPSEARCH_H_
#define _FTPSEARCH_H_


#include <qstringlist.h>
#include "searchjob.h"
class FtpSite;
class SiteManager;


class FtpSiteManager
{
public:
    FtpSiteManager();
    ~FtpSiteManager();
    FtpSite *find(const QString &name);
    QStringList siteList();
    
private:
    SiteManager *d;
};


class FtpSearch : public SearchJob
{
    Q_OBJECT
    
public:
    FtpSearch(FtpSite *site, const QString &searchtext);
    
signals:
    void foundItem(const QString &sitename, const QString &host, const QString &path,
                   const QString &size, const QString &date);
    
protected:
    virtual void parseItem(const QString &item);
};

#endif 
