#include <klocale.h>
#include <qframe.h>
#include <qvbox.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <kapp.h>
#include "krfboptions.h"

#include "kvncoptionsdlg.moc"

#include "kvncoptionsdlg.h"

KVNCOptionsDlg::KVNCOptionsDlg( KRFBOptions *options,
				QWidget *parent, char *name, bool modal )
  : KDialogBase( TreeList, i18n("Preferences"), Help|Default|Ok|Cancel,
		 Ok, parent, name, modal, true )
{
  this->options = options;

  setHelp( "kvnc/index.html", QString::null );

  QString item = i18n( "Connection Options" );
  QFrame *frame2 = addPage( item );
  setupConnectionPage( frame2 );

  item = i18n( "Data Encoding" );
  QString header = i18n("RFB data encoding priorities");

  QFrame *frame = addPage( item, header );
  setupEncodingPage( frame );
}

KVNCOptionsDlg::~KVNCOptionsDlg()
{

}

void KVNCOptionsDlg::slotDefault()
{

}

void KVNCOptionsDlg::slotOk()
{
  options->hexTile = hex->isChecked();
  options->corre = corre->isChecked();
  options->rre = rre->isChecked();
  options->copyrect = copyRect->isChecked();
  options->deIconify = deIconify->isChecked();
  options->colors256 = bit->isChecked();
  options->shared = shared->isChecked();

  done(1);
}

void KVNCOptionsDlg::setupEncodingPage( QFrame *frame )
{
  QVBoxLayout *outer = new QVBoxLayout( frame );
  QVBox *box = new QVBox( frame );
  outer->addWidget( box );

  hex = new QCheckBox("He&xtile encoding", box);
  corre = new QCheckBox("&CoRRE encoding",box);
  rre = new QCheckBox("&RRE encoding",box);
  copyRect = new QCheckBox("C&opy rectangle encoding",box);
  raw = new QCheckBox("Raw encoding (always enabled)",box);

  hex->setChecked( options->hexTile );
  corre->setChecked( options->corre );
  rre->setChecked( options->rre );
  copyRect->setChecked( options->copyrect );

  raw->setChecked( true );
  raw->setEnabled( false );

  // TODO
  hex->setEnabled( false );
  corre->setEnabled( false );
  rre->setEnabled( false );
  // /TODO

  outer->addStretch( 10 );
}

void KVNCOptionsDlg::setupConnectionPage( QFrame *frame )
{
  QVBoxLayout *outer = new QVBoxLayout( frame );

  QLabel *speedLabel = new QLabel( "&Check for screen updates every:",
                                   frame );

  QHBox *hbox = new QHBox( frame );
  QSpinBox *timeBox = new QSpinBox( 1, 20000, 1, hbox );
  hbox->setSpacing( spacingHint() );
  new QLabel( i18n( "Milliseconds" ), hbox );

  speedLabel->setBuddy( timeBox );
  outer->addWidget( speedLabel );
  outer->addSpacing( 4 );
  outer->addWidget( hbox );
  outer->addSpacing( 4 );

  QVBox *box2 = new QVBox( frame );
  outer->addWidget( box2 );

  bit = new QCheckBox( i18n( "Request &8-bit session" ), box2 );
  deIconify = new QCheckBox( i18n( "Deiconify on &bell" ), box2 );
  shared = new QCheckBox( i18n( "Request &shared session" ), box2 );

  deIconify->setChecked( options->deIconify );
  bit->setChecked( options->colors256 );
  shared->setChecked( options->shared );
}


