// -*- c++ -*-

#ifndef KVNC_H
#define KVNC_H

#include <ktmainwindow.h>

class KAction;
class KToggleAction;
class KRecentFilesAction;
class KRFBCanvas;
class QPushButton;

class KVNC : public KTMainWindow
{
  Q_OBJECT
public: 
  KVNC( const char *name = 0 );
  ~KVNC(); 

public slots:
  void toggleFullScreen();
  void toggleShowStatus();
  void toggleShowMenu();
  void openURL( const KURL &url );
  void showOptions();

protected:
  void setupActions();
  void setupMenuBar();
  void setupStatusBar();

protected slots:
  void showAboutApplication();

private:
  bool fullscreen;
  KRFBCanvas *canvas;
  KPopupMenu *cornerMenu;
  QPushButton *cornerButton;
};

#endif // KVNC_H
