/* 
 *  Copyright (C) 1999-2000 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#ifndef _WEB_H_
#define _WEB_H_ 

#include <qwidget.h>
#include <websearch.h>


class QLineEdit;
class QListView;
class QPushButton;
class QLabel;
class KHTMLPart;
class WebSiteManager;
class WebResultView;


class WebTopLevel : public QWidget
{
    Q_OBJECT

public:
    WebTopLevel(QWidget *parent, const char *name=0);
    ~WebTopLevel();

protected slots:
    void slotSearch();
    void slotCancel();
    void slotResult(KIO::Job *job);

    void processItem(const QString &sitename, const QString &title,
                     const QString &url, int relevance, const QString &details);
    void urlActivated(const QString &url);
    void detailsActivated(const QString &details);

private:
    QLineEdit *wordsedit;
    QListView *sitebox;
    QPushButton *searchbutton, *cancelbutton;
    WebResultView *resultbox;
    KHTMLPart *htmlpart;
    QLabel *foundlabel;
    QList<WebSearch> jobs;
    WebSiteManager *man;

    void updateButtons();
};
 
#endif 
