/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.ClassFakeOverrideReplacement;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@PhaseDescription(name="GenerateJvmDefaultCompatibilityBridges")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u001c\u0010\r\u001a\u00020\u0007*\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/GenerateJvmDefaultCompatibilityBridges;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "replaceWithDefaultCompatibilityBridgeIfNeeded", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "generateBridgeBody", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "superFunction", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nGenerateJvmDefaultCompatibilityBridges.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateJvmDefaultCompatibilityBridges.kt\norg/jetbrains/kotlin/backend/jvm/lower/GenerateJvmDefaultCompatibilityBridges\n+ 2 transform.kt\norg/jetbrains/kotlin/ir/util/TransformKt\n+ 3 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 4 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n26#2,4:67\n379#3,13:71\n133#4:84\n134#4:94\n406#5,5:85\n411#5:93\n1634#6,3:90\n*S KotlinDebug\n*F\n+ 1 GenerateJvmDefaultCompatibilityBridges.kt\norg/jetbrains/kotlin/backend/jvm/lower/GenerateJvmDefaultCompatibilityBridges\n*L\n37#1:67,4\n53#1:71,13\n53#1:84\n53#1:94\n60#1:85,5\n60#1:93\n60#1:90,3\n*E\n"})
public final class GenerateJvmDefaultCompatibilityBridges
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public GenerateJvmDefaultCompatibilityBridges(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        if (!this.context.getConfig().getJvmDefaultMode().isEnabled()) {
            return;
        }
        if (JvmIrUtilsKt.isJvmInterface(irClass)) {
            return;
        }
        List<IrDeclaration> $this$transformInPlace$iv = irClass.getDeclarations();
        boolean $i$f$transformInPlace = false;
        int n2 = $this$transformInPlace$iv.size();
        for (int i$iv = 0; i$iv < n2; ++i$iv) {
            IrElement irElement;
            void declaration;
            IrDeclaration irDeclaration = $this$transformInPlace$iv.get(i$iv);
            int n3 = i$iv;
            List<IrDeclaration> list = $this$transformInPlace$iv;
            boolean bl = false;
            IrDeclaration irDeclaration2 = this.replaceWithDefaultCompatibilityBridgeIfNeeded((IrDeclaration)declaration);
            IrElement irElement2 = irElement = irDeclaration2 != null ? (IrElement)irDeclaration2 : (IrElement)declaration;
            if (irElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
            }
            list.set(n3, (IrDeclaration)((IrElement)((IrDeclaration)irElement2)));
        }
    }

    private final IrDeclaration replaceWithDefaultCompatibilityBridgeIfNeeded(IrDeclaration declaration) {
        if (!(declaration instanceof IrSimpleFunction)) {
            return null;
        }
        ClassFakeOverrideReplacement classFakeOverrideReplacement = this.context.getCachedDeclarations().getClassFakeOverrideReplacement((IrSimpleFunction)declaration);
        ClassFakeOverrideReplacement.DefaultCompatibilityBridge defaultCompatibilityBridge = classFakeOverrideReplacement instanceof ClassFakeOverrideReplacement.DefaultCompatibilityBridge ? (ClassFakeOverrideReplacement.DefaultCompatibilityBridge)classFakeOverrideReplacement : null;
        if (defaultCompatibilityBridge == null) {
            return null;
        }
        ClassFakeOverrideReplacement.DefaultCompatibilityBridge defaultCompatibilityBridge2 = defaultCompatibilityBridge;
        IrSimpleFunction newFunction = defaultCompatibilityBridge2.component1();
        IrSimpleFunction superFunction = defaultCompatibilityBridge2.component2();
        this.generateBridgeBody(newFunction, (IrSimpleFunction)declaration, superFunction);
        return newFunction;
    }

    /*
     * WARNING - void declaration
     */
    private final void generateBridgeBody(IrSimpleFunction $this$generateBridgeBody, IrSimpleFunction declaration, IrSimpleFunction superFunction) {
        void $this$mapTo$iv$iv;
        void $this$assignFrom$iv;
        Object parameter;
        void $this$generateBridgeBody_u24lambda_u240_u240_u240;
        void $this$generateBridgeBody_u24lambda_u240_u240;
        IrCall irCall;
        void this_$iv$iv;
        DeclarationIrBuilder declarationIrBuilder;
        int offset = IrUtilsKt.getParentAsClass(declaration).getStartOffset();
        DeclarationIrBuilder $this$generateBridgeBody_u24lambda_u240 = declarationIrBuilder = LowerUtilsKt.createIrBuilder(this.context, (IrSymbol)$this$generateBridgeBody.getSymbol(), offset, offset);
        boolean bl = false;
        IrBuilderWithScope $this$irBlock_u24default$iv = $this$generateBridgeBody_u24lambda_u240;
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void var16_16 = this_$iv$iv;
        IrBuilder irBuilder = $this$generateBridgeBody_u24lambda_u240;
        IrSimpleFunction irSimpleFunction = $this$generateBridgeBody;
        boolean bl2 = false;
        IrCall irCall2 = irCall = ExpressionHelpersKt.irCall$default((IrBuilder)$this$generateBridgeBody_u24lambda_u240_u240, superFunction.getSymbol(), $this$generateBridgeBody.getReturnType(), 0, null, 12, null);
        void var22_22 = $this$generateBridgeBody_u24lambda_u240_u240;
        boolean bl3 = false;
        $this$generateBridgeBody_u24lambda_u240_u240_u240.setSuperQualifierSymbol(IrUtilsKt.getParentAsClass(superFunction).getSymbol());
        Object object = ((Iterable)$this$generateBridgeBody.getTypeParameters()).iterator();
        int n2 = 0;
        while (object.hasNext()) {
            int index = n2++;
            parameter = (IrTypeParameter)object.next();
            $this$generateBridgeBody_u24lambda_u240_u240_u240.getTypeArguments().set(index, IrTypesKt.getDefaultType((IrTypeParameter)parameter));
        }
        object = $this$generateBridgeBody_u24lambda_u240_u240_u240.getArguments();
        Collection other$iv = $this$generateBridgeBody.getParameters();
        boolean $i$f$assignFrom = false;
        $this$assignFrom$iv.clear();
        if ($this$assignFrom$iv instanceof ArrayList) {
            ((ArrayList)$this$assignFrom$iv).ensureCapacity(other$iv.size());
        }
        parameter = other$iv;
        Collection destination$iv$iv = (Collection)$this$assignFrom$iv;
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            IrValueDeclaration irValueDeclaration = (IrValueDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add(ExpressionHelpersKt.irGet((IrBuilder)$this$generateBridgeBody_u24lambda_u240_u240, (IrValueDeclaration)p0));
        }
        var22_22.unaryPlus(irCall);
        Unit unit = Unit.INSTANCE;
        irSimpleFunction.setBody(ExpressionHelpersKt.irExprBody(irBuilder, (IrExpression)this_$iv$iv.doBuild()));
    }
}

