/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.abel.DisplayPositioned;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandMultilinesCaption
extends CommandMultilines<TitledDiagram> {
    public static final CommandMultilinesCaption ME = new CommandMultilinesCaption();

    private CommandMultilinesCaption() {
        super(Pattern2.cmpile("^caption$"), Pattern2.cmpile("^end[%s]?caption$"));
    }

    @Override
    public CommandExecutionResult execute(TitledDiagram diagram, BlocLines lines, ParserPass currentPass) throws NoSuchColorException {
        LineLocation location = lines.getLocation();
        lines = lines.subExtract(1, 1);
        Display strings = (lines = lines.removeEmptyColumns()).toDisplay();
        if (strings.size() > 0) {
            diagram.setCaption(DisplayPositioned.single(location, strings.replaceBackslashT(), HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM));
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("No caption defined");
    }
}

