/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.auto.value.AutoBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableRangeSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.googlejavaformat.java.AutoBuilder_CommandLineOptions_Builder;
import java.util.Optional;

record CommandLineOptions(ImmutableList<String> files, boolean inPlace, ImmutableRangeSet<Integer> lines, ImmutableList<Integer> offsets, ImmutableList<Integer> lengths, boolean aosp, boolean version, boolean help, boolean stdin, boolean fixImportsOnly, boolean sortImports, boolean removeUnusedImports, boolean dryRun, boolean setExitIfChanged, Optional<String> assumeFilename, boolean reflowLongStrings, boolean formatJavadoc) {
    boolean isSelection() {
        return !this.lines().isEmpty() || !this.offsets().isEmpty() || !this.lengths().isEmpty();
    }

    static Builder builder() {
        return new AutoBuilder_CommandLineOptions_Builder().sortImports(true).removeUnusedImports(true).reflowLongStrings(true).formatJavadoc(true).aosp(false).version(false).help(false).stdin(false).fixImportsOnly(false).dryRun(false).setExitIfChanged(false).inPlace(false);
    }

    @AutoBuilder
    static interface Builder {
        public ImmutableList.Builder<String> filesBuilder();

        public Builder inPlace(boolean var1);

        public Builder lines(ImmutableRangeSet<Integer> var1);

        public ImmutableList.Builder<Integer> offsetsBuilder();

        @CanIgnoreReturnValue
        default public Builder addOffset(Integer offset) {
            this.offsetsBuilder().add((Object)offset);
            return this;
        }

        public ImmutableList.Builder<Integer> lengthsBuilder();

        @CanIgnoreReturnValue
        default public Builder addLength(Integer length) {
            this.lengthsBuilder().add((Object)length);
            return this;
        }

        public Builder aosp(boolean var1);

        public Builder version(boolean var1);

        public Builder help(boolean var1);

        public Builder stdin(boolean var1);

        public Builder fixImportsOnly(boolean var1);

        public Builder sortImports(boolean var1);

        public Builder removeUnusedImports(boolean var1);

        public Builder dryRun(boolean var1);

        public Builder setExitIfChanged(boolean var1);

        public Builder assumeFilename(String var1);

        public Builder reflowLongStrings(boolean var1);

        public Builder formatJavadoc(boolean var1);

        public CommandLineOptions build();
    }
}

