﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/iottwinmaker/IoTTwinMaker_EXPORTS.h>
#include <aws/iottwinmaker/model/DestinationConfiguration.h>
#include <aws/iottwinmaker/model/MetadataTransferJobProgress.h>
#include <aws/iottwinmaker/model/MetadataTransferJobStatus.h>
#include <aws/iottwinmaker/model/SourceConfiguration.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace IoTTwinMaker {
namespace Model {
class GetMetadataTransferJobResult {
 public:
  AWS_IOTTWINMAKER_API GetMetadataTransferJobResult() = default;
  AWS_IOTTWINMAKER_API GetMetadataTransferJobResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IOTTWINMAKER_API GetMetadataTransferJobResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The metadata transfer job Id.</p>
   */
  inline const Aws::String& GetMetadataTransferJobId() const { return m_metadataTransferJobId; }
  template <typename MetadataTransferJobIdT = Aws::String>
  void SetMetadataTransferJobId(MetadataTransferJobIdT&& value) {
    m_metadataTransferJobIdHasBeenSet = true;
    m_metadataTransferJobId = std::forward<MetadataTransferJobIdT>(value);
  }
  template <typename MetadataTransferJobIdT = Aws::String>
  GetMetadataTransferJobResult& WithMetadataTransferJobId(MetadataTransferJobIdT&& value) {
    SetMetadataTransferJobId(std::forward<MetadataTransferJobIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metadata transfer job ARN.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  GetMetadataTransferJobResult& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metadata transfer job description.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  GetMetadataTransferJobResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metadata transfer job's sources.</p>
   */
  inline const Aws::Vector<SourceConfiguration>& GetSources() const { return m_sources; }
  template <typename SourcesT = Aws::Vector<SourceConfiguration>>
  void SetSources(SourcesT&& value) {
    m_sourcesHasBeenSet = true;
    m_sources = std::forward<SourcesT>(value);
  }
  template <typename SourcesT = Aws::Vector<SourceConfiguration>>
  GetMetadataTransferJobResult& WithSources(SourcesT&& value) {
    SetSources(std::forward<SourcesT>(value));
    return *this;
  }
  template <typename SourcesT = SourceConfiguration>
  GetMetadataTransferJobResult& AddSources(SourcesT&& value) {
    m_sourcesHasBeenSet = true;
    m_sources.emplace_back(std::forward<SourcesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metadata transfer job's destination.</p>
   */
  inline const DestinationConfiguration& GetDestination() const { return m_destination; }
  template <typename DestinationT = DestinationConfiguration>
  void SetDestination(DestinationT&& value) {
    m_destinationHasBeenSet = true;
    m_destination = std::forward<DestinationT>(value);
  }
  template <typename DestinationT = DestinationConfiguration>
  GetMetadataTransferJobResult& WithDestination(DestinationT&& value) {
    SetDestination(std::forward<DestinationT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metadata transfer job's role.</p>
   */
  inline const Aws::String& GetMetadataTransferJobRole() const { return m_metadataTransferJobRole; }
  template <typename MetadataTransferJobRoleT = Aws::String>
  void SetMetadataTransferJobRole(MetadataTransferJobRoleT&& value) {
    m_metadataTransferJobRoleHasBeenSet = true;
    m_metadataTransferJobRole = std::forward<MetadataTransferJobRoleT>(value);
  }
  template <typename MetadataTransferJobRoleT = Aws::String>
  GetMetadataTransferJobResult& WithMetadataTransferJobRole(MetadataTransferJobRoleT&& value) {
    SetMetadataTransferJobRole(std::forward<MetadataTransferJobRoleT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metadata transfer job's report URL.</p>
   */
  inline const Aws::String& GetReportUrl() const { return m_reportUrl; }
  template <typename ReportUrlT = Aws::String>
  void SetReportUrl(ReportUrlT&& value) {
    m_reportUrlHasBeenSet = true;
    m_reportUrl = std::forward<ReportUrlT>(value);
  }
  template <typename ReportUrlT = Aws::String>
  GetMetadataTransferJobResult& WithReportUrl(ReportUrlT&& value) {
    SetReportUrl(std::forward<ReportUrlT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metadata transfer job's creation DateTime property.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationDateTime() const { return m_creationDateTime; }
  template <typename CreationDateTimeT = Aws::Utils::DateTime>
  void SetCreationDateTime(CreationDateTimeT&& value) {
    m_creationDateTimeHasBeenSet = true;
    m_creationDateTime = std::forward<CreationDateTimeT>(value);
  }
  template <typename CreationDateTimeT = Aws::Utils::DateTime>
  GetMetadataTransferJobResult& WithCreationDateTime(CreationDateTimeT&& value) {
    SetCreationDateTime(std::forward<CreationDateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metadata transfer job's update DateTime property.</p>
   */
  inline const Aws::Utils::DateTime& GetUpdateDateTime() const { return m_updateDateTime; }
  template <typename UpdateDateTimeT = Aws::Utils::DateTime>
  void SetUpdateDateTime(UpdateDateTimeT&& value) {
    m_updateDateTimeHasBeenSet = true;
    m_updateDateTime = std::forward<UpdateDateTimeT>(value);
  }
  template <typename UpdateDateTimeT = Aws::Utils::DateTime>
  GetMetadataTransferJobResult& WithUpdateDateTime(UpdateDateTimeT&& value) {
    SetUpdateDateTime(std::forward<UpdateDateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metadata transfer job's status.</p>
   */
  inline const MetadataTransferJobStatus& GetStatus() const { return m_status; }
  template <typename StatusT = MetadataTransferJobStatus>
  void SetStatus(StatusT&& value) {
    m_statusHasBeenSet = true;
    m_status = std::forward<StatusT>(value);
  }
  template <typename StatusT = MetadataTransferJobStatus>
  GetMetadataTransferJobResult& WithStatus(StatusT&& value) {
    SetStatus(std::forward<StatusT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metadata transfer job's progress.</p>
   */
  inline const MetadataTransferJobProgress& GetProgress() const { return m_progress; }
  template <typename ProgressT = MetadataTransferJobProgress>
  void SetProgress(ProgressT&& value) {
    m_progressHasBeenSet = true;
    m_progress = std::forward<ProgressT>(value);
  }
  template <typename ProgressT = MetadataTransferJobProgress>
  GetMetadataTransferJobResult& WithProgress(ProgressT&& value) {
    SetProgress(std::forward<ProgressT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetMetadataTransferJobResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_metadataTransferJobId;

  Aws::String m_arn;

  Aws::String m_description;

  Aws::Vector<SourceConfiguration> m_sources;

  DestinationConfiguration m_destination;

  Aws::String m_metadataTransferJobRole;

  Aws::String m_reportUrl;

  Aws::Utils::DateTime m_creationDateTime{};

  Aws::Utils::DateTime m_updateDateTime{};

  MetadataTransferJobStatus m_status;

  MetadataTransferJobProgress m_progress;

  Aws::String m_requestId;
  bool m_metadataTransferJobIdHasBeenSet = false;
  bool m_arnHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_sourcesHasBeenSet = false;
  bool m_destinationHasBeenSet = false;
  bool m_metadataTransferJobRoleHasBeenSet = false;
  bool m_reportUrlHasBeenSet = false;
  bool m_creationDateTimeHasBeenSet = false;
  bool m_updateDateTimeHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_progressHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTTwinMaker
}  // namespace Aws
