/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.functions;

import jakarta.servlet.jsp.JspTagException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.Util;

public class Functions {
    public static String toUpperCase(String input) {
        return input.toUpperCase();
    }

    public static String toLowerCase(String input) {
        return input.toLowerCase();
    }

    public static int indexOf(String input, String substring) {
        if (input == null) {
            input = "";
        }
        if (substring == null) {
            substring = "";
        }
        return input.indexOf(substring);
    }

    public static boolean contains(String input, String substring) {
        return Functions.indexOf(input, substring) != -1;
    }

    public static boolean containsIgnoreCase(String input, String substring) {
        String substringUC;
        String inputUC;
        if (input == null) {
            input = "";
        }
        if (substring == null) {
            substring = "";
        }
        return Functions.indexOf(inputUC = input.toUpperCase(), substringUC = substring.toUpperCase()) != -1;
    }

    public static boolean startsWith(String input, String substring) {
        if (input == null) {
            input = "";
        }
        if (substring == null) {
            substring = "";
        }
        return input.startsWith(substring);
    }

    public static boolean endsWith(String input, String substring) {
        if (input == null) {
            input = "";
        }
        if (substring == null) {
            substring = "";
        }
        return input.endsWith(substring);
    }

    public static String substring(String input, int beginIndex, int endIndex) {
        if (input == null) {
            input = "";
        }
        if (beginIndex >= input.length()) {
            return "";
        }
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (endIndex < 0 || endIndex > input.length()) {
            endIndex = input.length();
        }
        if (endIndex < beginIndex) {
            return "";
        }
        return input.substring(beginIndex, endIndex);
    }

    public static String substringAfter(String input, String substring) {
        if (input == null) {
            input = "";
        }
        if (input.length() == 0) {
            return "";
        }
        if (substring == null) {
            substring = "";
        }
        if (substring.length() == 0) {
            return input;
        }
        int index = input.indexOf(substring);
        if (index == -1) {
            return "";
        }
        return input.substring(index + substring.length());
    }

    public static String substringBefore(String input, String substring) {
        if (input == null) {
            input = "";
        }
        if (input.length() == 0) {
            return "";
        }
        if (substring == null) {
            substring = "";
        }
        if (substring.length() == 0) {
            return "";
        }
        int index = input.indexOf(substring);
        if (index == -1) {
            return "";
        }
        return input.substring(0, index);
    }

    public static String escapeXml(String input) {
        if (input == null) {
            return "";
        }
        return Util.escapeXml(input);
    }

    public static String trim(String input) {
        if (input == null) {
            return "";
        }
        return input.trim();
    }

    public static String replace(String input, String substringBefore, String substringAfter) {
        int index;
        if (input == null) {
            input = "";
        }
        if (input.length() == 0) {
            return "";
        }
        if (substringBefore == null) {
            substringBefore = "";
        }
        if (substringBefore.length() == 0) {
            return input;
        }
        StringBuffer buf = new StringBuffer(input.length());
        int startIndex = 0;
        while ((index = input.indexOf(substringBefore, startIndex)) != -1) {
            buf.append(input.substring(startIndex, index)).append(substringAfter);
            startIndex = index + substringBefore.length();
        }
        return buf.append(input.substring(startIndex)).toString();
    }

    public static String[] split(String input, String delimiters) {
        if (input == null) {
            input = "";
        }
        if (input.length() == 0) {
            String[] array = new String[]{""};
            return array;
        }
        if (delimiters == null) {
            delimiters = "";
        }
        StringTokenizer tok = new StringTokenizer(input, delimiters);
        int count = tok.countTokens();
        String[] array = new String[count];
        int i = 0;
        while (tok.hasMoreTokens()) {
            array[i++] = tok.nextToken();
        }
        return array;
    }

    public static int length(Object obj) throws JspTagException {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof String) {
            return ((String)obj).length();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj instanceof Map) {
            return ((Map)obj).size();
        }
        int count = 0;
        if (obj instanceof Iterator) {
            Iterator iter = (Iterator)obj;
            count = 0;
            while (iter.hasNext()) {
                ++count;
                iter.next();
            }
            return count;
        }
        if (obj instanceof Enumeration) {
            Enumeration enum_ = (Enumeration)obj;
            count = 0;
            while (enum_.hasMoreElements()) {
                ++count;
                enum_.nextElement();
            }
            return count;
        }
        try {
            count = Array.getLength(obj);
            return count;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JspTagException(Resources.getMessage("FOREACH_BAD_ITEMS"));
        }
    }

    public static String join(String[] array, String separator) {
        if (array == null) {
            return "";
        }
        if (separator == null) {
            separator = "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            buf.append(array[i]);
            if (i >= array.length - 1) continue;
            buf.append(separator);
        }
        return buf.toString();
    }
}

